/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.json;

import com.atlassian.util.concurrent.LazyReference;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONResult
implements Result {
    private static final Log LOG = LogFactory.getLog(JSONResult.class);
    private String jsonObjectProperty = "jsonObject";
    private String contentType = "application/json";
    private static final LazyReference<Charset> CHARSET = new LazyReference<Charset>(){

        protected Charset create() throws Exception {
            String charset = Configuration.getString("webwork.i18n.encoding");
            return Charset.forName(charset);
        }
    };

    public String getJSONObjectProperty() {
        return this.jsonObjectProperty;
    }

    public void setJSONObjectProperty(String jsonObject) {
        this.jsonObjectProperty = jsonObject;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        JSONObject jsonObject;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"executing JSONResult");
        }
        if ((jsonObject = this.getJSONObject(invocation)) != null) {
            String json = jsonObject.toString();
            HttpServletResponse response = this.getServletResponse(invocation);
            Charset charset = (Charset)CHARSET.get();
            byte[] content = json.getBytes(charset.name());
            response.setContentType(this.getContentType() + ";charset=" + charset.name());
            response.setContentLength(content.length);
            ServletOutputStream os = response.getOutputStream();
            os.write(content);
            os.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("written [" + json + "] to HttpServletResponse outputstream"));
            }
        }
    }

    protected JSONObject getJSONObject(ActionInvocation invocation) throws JSONException {
        ActionContext actionContext = invocation.getInvocationContext();
        Object obj = actionContext.getValueStack().findValue(this.jsonObjectProperty);
        if (obj == null) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] returns null, expecting JSONObject"), (Throwable)((Object)new WebWorkException()));
            return null;
        }
        if (!JSONObject.class.isInstance(obj)) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] is [" + obj + "] especting an instance of JSONObject"), (Throwable)((Object)new WebWorkException()));
            return null;
        }
        return (JSONObject)obj;
    }

    protected HttpServletResponse getServletResponse(ActionInvocation invocation) {
        return (HttpServletResponse)invocation.getInvocationContext().getContextMap().get("com.opensymphony.xwork.dispatcher.HttpServletResponse");
    }
}

