/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.webwork.components.template.TemplateEngine;
import java.util.ArrayList;
import java.util.List;

public class Template
implements Cloneable {
    String dir;
    String theme;
    String name;

    public Template(String dir, String theme, String name) {
        this.dir = dir;
        this.theme = theme;
        this.name = name;
    }

    public String getDir() {
        return this.dir;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getName() {
        return this.name;
    }

    public List getPossibleTemplates(TemplateEngine engine) {
        String parentTheme;
        ArrayList<Template> list = new ArrayList<Template>(3);
        Template template = this;
        list.add(template);
        while ((parentTheme = (String)engine.getThemeProps(template).get("parent")) != null) {
            try {
                template = (Template)template.clone();
                template.theme = parentTheme;
                list.add(template);
            }
            catch (CloneNotSupportedException e) {}
        }
        return list;
    }

    public String toString() {
        return "/" + this.dir + "/" + this.theme + "/" + this.name;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

