/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Property
extends Component {
    private static final Log LOG = LogFactory.getLog(Property.class);
    private String defaultValue;
    private String value;
    private boolean escape = true;

    public Property(OgnlValueStack stack) {
        super(stack);
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        String actualValue = null;
        if (this.value == null) {
            this.value = "top";
        } else if (this.altSyntax() && this.value.startsWith("%{") && this.value.endsWith("}")) {
            this.value = this.value.substring(2, this.value.length() - 1);
        }
        actualValue = (String)this.getStack().findValue(this.value, String.class);
        try {
            if (actualValue != null) {
                writer.write(this.prepare(actualValue));
            } else if (this.defaultValue != null) {
                writer.write(this.prepare(this.defaultValue));
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Could not print out value '" + this.value + "'"), (Throwable)e);
        }
        return result;
    }

    private String prepare(String value) {
        if (this.escape) {
            return TextUtils.htmlEncode((String)value);
        }
        return value;
    }
}

