/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRichtexteditorConnector
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private static final Log _log = LogFactory.getLog(AbstractRichtexteditorConnector.class);
    public static String GET_FOLDERS = "getFolders";
    public static String GET_FOLDERS_AND_FILES = "getFoldersAndFiles";
    public static String CREATE_FOLDER = "createFolder";
    public static String FILE_UPLOAD = "fileUpload";
    protected HttpServletRequest _request;
    protected HttpServletResponse _response;
    protected java.io.File _newFile;
    protected String _newFileFileName;
    protected String _newFileContentType;
    protected String _type;
    protected String _command;
    protected String _currentFolder;
    protected String _serverPath = "/webwork/richtexteditor/data/";
    protected String _newFolderName;

    public String browse() throws Exception {
        if ("GetFolders".equals(this.getCommand())) {
            _log.debug((Object)("Command " + this.getCommand() + " detected \n\t type=" + this.getType() + "\n\t folderPath=" + this.getCurrentFolder()));
            ActionContext.getContext().put((Object)"__richtexteditorCommand", (Object)this.getCommand());
            ActionContext.getContext().put((Object)"__richtexteditorType", (Object)this.getType());
            ActionContext.getContext().put((Object)"__richtexteditorFolderPath", (Object)this.getCurrentFolder());
            ActionContext.getContext().put((Object)"__richtexteditorServerPath", (Object)this.calculateServerPath(this.getServerPath(), this.getCurrentFolder(), this.getType()));
            Folder[] folders = this.getFolders(this.getCurrentFolder(), this.getType());
            ActionContext.getContext().put((Object)"__richtexteditorGetFolders", (Object)folders);
            return GET_FOLDERS;
        }
        if ("GetFoldersAndFiles".equals(this.getCommand())) {
            _log.debug((Object)("Command " + this.getCommand() + " detected \n\t type=" + this.getType() + "\n\t folderPath=" + this.getCurrentFolder()));
            ActionContext.getContext().put((Object)"__richtexteditorCommand", (Object)this.getCommand());
            ActionContext.getContext().put((Object)"__richtexteditorType", (Object)this.getType());
            ActionContext.getContext().put((Object)"__richtexteditorFolderPath", (Object)this.getCurrentFolder());
            ActionContext.getContext().put((Object)"__richtexteditorServerPath", (Object)this.calculateServerPath(this.getServerPath(), this.getCurrentFolder(), this.getType()));
            FoldersAndFiles folderAndFiles = this.getFoldersAndFiles(this.getCurrentFolder(), this.getType());
            ActionContext.getContext().put((Object)"__richtexteditorGetFoldersAndFiles", (Object)folderAndFiles);
            return GET_FOLDERS_AND_FILES;
        }
        if ("CreateFolder".equals(this.getCommand())) {
            _log.debug((Object)("Command " + this.getCommand() + " detected \n\t type=" + this.getType() + "\n\t folderPath=" + this.getCurrentFolder() + "\n\t newFolderName=" + this.getNewFolderName()));
            ActionContext.getContext().put((Object)"__richtexteditorCommand", (Object)this.getCommand());
            ActionContext.getContext().put((Object)"__richtexteditorType", (Object)this.getType());
            ActionContext.getContext().put((Object)"__richtexteditorFolderPath", (Object)this.getCurrentFolder());
            ActionContext.getContext().put((Object)"__richtexteditorServerPath", (Object)this.calculateServerPath(this.getServerPath(), this.getCurrentFolder(), this.getType()));
            CreateFolderResult createFolderResult = this.createFolder(this.getCurrentFolder(), this.getType(), this.getNewFolderName());
            ActionContext.getContext().put((Object)"__richtexteditorCreateFolder", (Object)createFolderResult);
            return CREATE_FOLDER;
        }
        if ("FileUpload".equals(this.getCommand())) {
            _log.debug((Object)("Command " + this.getCommand() + " detected \n\t type=" + this.getType() + "\n\t folderPath=" + this.getCurrentFolder() + "\n\t newFileFileName=" + this.getNewFileFileName() + "\n\t newFileContentType=" + this.getNewFileContentType() + "\n\t newFile=" + this.getNewFile()));
            ActionContext.getContext().put((Object)"__richtexteditorCommand", (Object)this.getCommand());
            FileUploadResult fileUploadResult = this.fileUpload(this.getCurrentFolder(), this.getType(), this.getNewFileFileName(), this.getNewFileContentType(), this.getNewFile());
            ActionContext.getContext().put((Object)"__richtexteditorFileUpload", (Object)fileUploadResult);
            return FILE_UPLOAD;
        }
        _log.debug((Object)("Unknown Command " + this.getCommand() + " detected \n\t type=" + this.getType() + "\n\t folderPath=" + this.getCurrentFolder()));
        this.unknownCommand(this.getCommand(), this.getCurrentFolder(), this.getType(), this.getNewFileFileName(), this.getNewFileContentType(), this.getNewFile());
        return "error";
    }

    public String upload() throws Exception {
        _log.debug((Object)("Upload detected \n\t type=" + this.getType() + "\n\t newFileFileName=" + this.getNewFileFileName() + "\n\t newFileContentType=" + this.getNewFileContentType() + "\n\t newFile=" + this.getNewFile()));
        FileUploadResult fileUploadResult = this.fileUpload("/", this.getType(), this.getNewFileFileName(), this.getNewFileContentType(), this.getNewFile());
        ActionContext.getContext().put((Object)"__richtexteditorFileUpload", (Object)fileUploadResult);
        return FILE_UPLOAD;
    }

    protected abstract String calculateServerPath(String var1, String var2, String var3) throws Exception;

    protected abstract Folder[] getFolders(String var1, String var2) throws Exception;

    protected abstract FoldersAndFiles getFoldersAndFiles(String var1, String var2) throws Exception;

    protected abstract CreateFolderResult createFolder(String var1, String var2, String var3) throws Exception;

    protected abstract FileUploadResult fileUpload(String var1, String var2, String var3, String var4, java.io.File var5) throws Exception;

    protected abstract void unknownCommand(String var1, String var2, String var3, String var4, String var5, java.io.File var6) throws Exception;

    public java.io.File getNewFile() {
        return this._newFile;
    }

    public void setNewFile(java.io.File newFile) {
        this._newFile = newFile;
    }

    public String getNewFileFileName() {
        return this._newFileFileName;
    }

    public void setNewFileFileName(String newFileFileName) {
        this._newFileFileName = newFileFileName;
    }

    public String getNewFileContentType() {
        return this._newFileContentType;
    }

    public void setNewFileContentType(String newFileContentType) {
        this._newFileContentType = newFileContentType;
    }

    public String getCommand() {
        return this._command;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getCurrentFolder() {
        return this._currentFolder;
    }

    public void setCurrentFolder(String currentFolder) {
        this._currentFolder = currentFolder;
    }

    public String getNewFolderName() {
        return this._newFolderName;
    }

    public void setNewFolderName(String newFolderName) {
        this._newFolderName = newFolderName;
    }

    public String getServerPath() {
        return this._serverPath;
    }

    public void setServerPath(String serverPath) {
        this._serverPath = serverPath;
    }

    public void setServletRequest(HttpServletRequest request) {
        this._request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this._response = response;
    }

    public static class FileUploadResult
    implements Serializable {
        private static final FileUploadResult UPLOAD_COMPLETED = new FileUploadResult("0");
        private static final FileUploadResult INVALID_FILE = new FileUploadResult("202");
        private String code;
        private String filename;

        private FileUploadResult(String code) {
            this(code, null);
        }

        private FileUploadResult(String code, String newFilename) {
            this.code = code;
            this.filename = newFilename;
        }

        public String getCode() {
            return this.code;
        }

        public String getFilename() {
            return this.filename;
        }

        public static FileUploadResult uploadComplete() {
            return UPLOAD_COMPLETED;
        }

        public static FileUploadResult invalidFile() {
            return INVALID_FILE;
        }

        public static FileUploadResult uploadCompleteWithFilenamChanged(String newFilename) {
            assert (newFilename != null);
            return new FileUploadResult("201", newFilename);
        }
    }

    public static class CreateFolderResult
    implements Serializable {
        public static final CreateFolderResult NO_ERRORS = new CreateFolderResult("0");
        public static final CreateFolderResult FOLDER_ALREADY_EXISTS = new CreateFolderResult("101");
        public static final CreateFolderResult INVALID_FOLDER_NAME = new CreateFolderResult("102");
        public static final CreateFolderResult NO_PERMISSION = new CreateFolderResult("103");
        public static final CreateFolderResult UNKNOWN_ERROR = new CreateFolderResult("110");
        private String code;

        private CreateFolderResult(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static CreateFolderResult noErrors() {
            return NO_ERRORS;
        }

        public static CreateFolderResult folderAlreadyExists() {
            return FOLDER_ALREADY_EXISTS;
        }

        public static CreateFolderResult invalidFolderName() {
            return INVALID_FOLDER_NAME;
        }

        public static CreateFolderResult noPermission() {
            return NO_PERMISSION;
        }

        public static CreateFolderResult unknownError() {
            return UNKNOWN_ERROR;
        }
    }

    public static class FoldersAndFiles
    implements Serializable {
        private Folder[] folders;
        private File[] files;

        public FoldersAndFiles(Folder[] folders, File[] files) {
            this.folders = folders;
            this.files = files;
        }

        public Folder[] getFolders() {
            return this.folders;
        }

        public File[] getFiles() {
            return this.files;
        }
    }

    public static class File
    implements Serializable {
        private String filename;
        private long sizeInKb;

        public File(String filename, long sizeInKb) {
            assert (filename != null);
            this.filename = filename;
            this.sizeInKb = sizeInKb;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSizeInKb() {
            return this.sizeInKb;
        }
    }

    public static class Folder
    implements Serializable {
        private String foldername;

        public Folder(String foldername) {
            assert (foldername != null);
            this.foldername = foldername;
        }

        public String getFoldername() {
            return this.foldername;
        }
    }
}

