/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.xwork.ObjectFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeActionMapper
implements ActionMapper {
    private static final Log LOG = LogFactory.getLog((Class)CompositeActionMapper.class);
    private List actionMappers = new ArrayList();

    public CompositeActionMapper() {
        Iterator i = Configuration.list();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if (!propertyName.startsWith("webwork.compositeActionMapper.")) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found CompositeActionMapper order property [" + propertyName + "]"));
            }
            String orderAsString = propertyName.substring("webwork.compositeActionMapper.".length());
            try {
                int order = Integer.parseInt(orderAsString);
                String actionMapperClassName = Configuration.getString(propertyName);
                if (actionMapperClassName == null || actionMapperClassName.trim().length() <= 0) {
                    LOG.warn((Object)("property [" + propertyName + "] doesn't contains an ActionMapper class name, it will be ignored"));
                    continue;
                }
                try {
                    this.actionMappers.add(new ActionMapperInfo(order, (ActionMapper)ObjectFactory.getObjectFactory().buildBean(actionMapperClassName.trim(), Collections.EMPTY_MAP)));
                }
                catch (Exception e) {
                    LOG.warn((Object)("failed to create ActionMapper [" + actionMapperClassName.trim() + "] defined in property [" + propertyName + "]"), (Throwable)e);
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("unable to recognize the order from property [" + propertyName + "], this property configuration will be ignored"));
            }
        }
        Collections.sort(this.actionMappers);
    }

    public CompositeActionMapper(ActionMapper[] actionMappers) {
        for (int a = 0; a < actionMappers.length; ++a) {
            if (actionMappers[a] != null) {
                this.actionMappers.add(new ActionMapperInfo(a, actionMappers[a]));
                continue;
            }
            LOG.warn((Object)("ActionMapper given at index[" + a + "] is null, it will be ignored"));
        }
    }

    public ActionMapping getMapping(HttpServletRequest request) {
        Iterator i = this.actionMappers.iterator();
        while (i.hasNext()) {
            ActionMapping actionMapping;
            ActionMapperInfo info = (ActionMapperInfo)i.next();
            ActionMapper actionMapper = info.getActionMapper();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to get ActionMapping from ActionMapper [" + actionMapper + "] with order [" + info.getOrder() + "] in CompositeActionMapper"));
            }
            if ((actionMapping = actionMapper.getMapping(request)) == null) continue;
            return actionMapping;
        }
        LOG.info((Object)"failed to find a valid (non-null) ActionMapping from all preconfigured ActionMappers");
        return null;
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        Iterator i = this.actionMappers.iterator();
        while (i.hasNext()) {
            String uri;
            ActionMapperInfo info = (ActionMapperInfo)i.next();
            ActionMapper actionMapper = info.getActionMapper();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to get Uri from ActionMapper [" + actionMapper + "] with order [" + info.getOrder() + "] in CompositeActionMapper"));
            }
            if ((uri = actionMapper.getUriFromActionMapping(mapping)) == null || uri.trim().length() <= 0) continue;
            return uri;
        }
        LOG.info((Object)"failed to find a valid (non-null) URI from all preconfigured ActionMappers");
        return null;
    }

    protected List getActionMapperInfos() {
        return this.actionMappers;
    }

    protected class ActionMapperInfo
    implements Comparable {
        private int order;
        private ActionMapper actionMapper;

        private ActionMapperInfo(int order, ActionMapper actionMapper) {
            this.order = order;
            this.actionMapper = actionMapper;
        }

        public int getOrder() {
            return this.order;
        }

        public ActionMapper getActionMapper() {
            return this.actionMapper;
        }

        public int compareTo(Object o) {
            ActionMapperInfo _tmp = (ActionMapperInfo)o;
            return this.order - _tmp.order;
        }
    }
}

