/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker.tags;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.views.freemarker.tags.CallbackWriter;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TagModel
implements TemplateTransformModel {
    private static final Log LOG = LogFactory.getLog((Class)TagModel.class);
    protected OgnlValueStack stack;
    protected HttpServletRequest req;
    protected HttpServletResponse res;

    public TagModel(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        this.stack = stack;
        this.req = req;
        this.res = res;
    }

    public Writer getWriter(Writer writer, Map params) throws TemplateModelException, IOException {
        Component bean = this.getBean();
        Map unwrappedParameters = this.unwrapParameters(params);
        bean.copyParams(unwrappedParameters);
        return new CallbackWriter(bean, writer);
    }

    protected Map unwrapParameters(Map params) {
        HashMap map = new HashMap(params.size());
        DefaultObjectWrapper objectWrapper = new DefaultObjectWrapper();
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof TemplateModel) {
                try {
                    map.put(entry.getKey(), objectWrapper.unwrap((TemplateModel)value));
                }
                catch (TemplateModelException e) {
                    LOG.error((Object)("failed to unwrap [" + value + "] it will be ignored"), (Throwable)e);
                }
                continue;
            }
            map.put(entry.getKey(), value.toString());
        }
        return map;
    }

    protected abstract Component getBean();
}

