/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.json;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONResult
implements Result {
    private static final Log LOG = LogFactory.getLog((Class)JSONResult.class);
    private String jsonObjectProperty = "jsonObject";
    private String contentType = "application/json";

    public String getJSONObjectProperty() {
        return this.jsonObjectProperty;
    }

    public void setJSONObjectProperty(String jsonObject) {
        this.jsonObjectProperty = jsonObject;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        JSONObject jsonObject;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"executing JSONResult");
        }
        if ((jsonObject = this.getJSONObject(invocation)) != null) {
            String json = jsonObject.toString();
            HttpServletResponse response = this.getServletResponse(invocation);
            response.setContentType(this.getContentType());
            response.setContentLength(json.getBytes().length);
            ServletOutputStream os = response.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("written [" + json + "] to HttpServletResponse outputstream"));
            }
        }
    }

    protected JSONObject getJSONObject(ActionInvocation invocation) throws JSONException {
        ActionContext actionContext = invocation.getInvocationContext();
        Object obj = actionContext.getValueStack().findValue(this.jsonObjectProperty);
        if (obj == null) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] returns null, expecting JSONObject"), (Throwable)((Object)new WebWorkException()));
            return null;
        }
        if (!JSONObject.class.isInstance(obj)) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] is [" + obj + "] especting an instance of JSONObject"), (Throwable)((Object)new WebWorkException()));
            return null;
        }
        return (JSONObject)obj;
    }

    protected HttpServletResponse getServletResponse(ActionInvocation invocation) {
        return (HttpServletResponse)invocation.getInvocationContext().getContextMap().get("com.opensymphony.xwork.dispatcher.HttpServletResponse");
    }
}

