/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bean
extends Component {
    protected static Log log = LogFactory.getLog((Class)Bean.class);
    protected Object bean;
    protected String name;

    public Bean(OgnlValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        OgnlValueStack stack = this.getStack();
        try {
            String beanName = this.findString(this.name, "name", "Bean name is required. Example: com.acme.FooBean");
            this.bean = ObjectFactory.getObjectFactory().buildBean(ClassLoaderUtil.loadClass((String)beanName, this.getClass()), stack.getContext());
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate bean", (Throwable)e);
            return false;
        }
        stack.push(this.bean);
        if (this.getId() != null) {
            this.getStack().getContext().put(this.getId(), this.bean);
        }
        return result;
    }

    public boolean end(Writer writer, String body) {
        OgnlValueStack stack = this.getStack();
        stack.pop();
        return super.end(writer, body);
    }

    public void addParameter(String key, Object value) {
        OgnlUtil.setProperty((String)key, (Object)value, (Object)this.bean, (Map)this.getStack().getContext());
    }

    public void setName(String name) {
        this.name = name;
    }
}

