/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ApplicationMap;
import com.opensymphony.webwork.dispatcher.RequestMap;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.util.AttributeMap;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletDispatcher
extends HttpServlet
implements WebWorkStatics {
    protected static final Log log = LogFactory.getLog(ServletDispatcher.class);
    boolean paramsWorkaroundEnabled = false;

    public static String getNamespaceFromServletPath(String servletPath) {
        servletPath = servletPath.substring(0, servletPath.lastIndexOf("/"));
        return servletPath;
    }

    public static HashMap createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", parameterMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.application", applicationMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.locale", request.getLocale());
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletRequest", request);
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletResponse", response);
        extraContext.put("com.opensymphony.xwork.dispatcher.ServletConfig", servletConfig);
        extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", request.getAttribute("DefaultComponentManager"));
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        LocalizedTextUtil.addDefaultResourceBundle((String)"com/opensymphony/webwork/webwork-messages");
        if ("true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        servletConfig.getServletContext().setAttribute("webwork.servlet", (Object)this);
        if (servletConfig.getServletContext().getServerInfo().indexOf("WebLogic") >= 0) {
            log.info((Object)"WebLogic server detected. Enabling parameter access work-around.");
            this.paramsWorkaroundEnabled = true;
        } else {
            log.debug((Object)"Parameter access work-around disabled.");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (this.paramsWorkaroundEnabled) {
                request.getParameter("foo");
            }
            request = this.wrapRequest(request);
            this.serviceAction(request, response, this.getNameSpace(request), this.getActionName(request), this.getRequestMap(request), this.getParameterMap(request), this.getSessionMap(request), this.getApplicationMap());
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            log.error((Object)message, (Throwable)e);
            this.sendError(request, response, 500, (Exception)new ServletException(message, (Throwable)e));
        }
    }

    public void serviceAction(HttpServletRequest request, HttpServletResponse response, String namespace, String actionName, Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap) {
        HashMap extraContext = ServletDispatcher.createContextMap(requestMap, parameterMap, sessionMap, applicationMap, request, response, this.getServletConfig());
        extraContext.put("com.opensymphony.xwork.dispatcher.ServletDispatcher", this);
        try {
            ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, actionName, (Map)extraContext);
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            proxy.execute();
        }
        catch (ConfigurationException e) {
            log.error((Object)"Could not find action", (Throwable)e);
            this.sendError(request, response, 404, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)"Could not execute action", (Throwable)e);
            this.sendError(request, response, 500, e);
        }
    }

    protected String getActionName(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        return this.getActionName(servletPath);
    }

    protected String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.lastIndexOf(".");
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }

    protected Map getApplicationMap() {
        return new ApplicationMap(this.getServletContext());
    }

    protected String getNameSpace(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return ServletDispatcher.getNamespaceFromServletPath(servletPath);
    }

    protected Map getParameterMap(HttpServletRequest request) throws IOException {
        return request.getParameterMap();
    }

    protected Map getRequestMap(HttpServletRequest request) {
        return new RequestMap(request);
    }

    protected Map getSessionMap(HttpServletRequest request) {
        return new SessionMap(request);
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, int code, Exception e) {
        try {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            response.sendError(code, e.getMessage());
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request) throws IOException {
        if (request instanceof MultiPartRequestWrapper) {
            return request;
        }
        if (MultiPartRequest.isMultiPart(request)) {
            request = new MultiPartRequestWrapper((HttpServletRequest)request, this.getSaveDir(), this.getMaxSize());
        }
        return request;
    }

    protected String getSaveDir() {
        String saveDir = Configuration.getString("webwork.multipart.saveDir").trim();
        if (saveDir.equals("")) {
            File tempdir = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
            log.info((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
            if (tempdir != null) {
                saveDir = tempdir.toString();
            }
        } else {
            File multipartSaveDir = new File(saveDir);
            if (!multipartSaveDir.exists()) {
                multipartSaveDir.mkdir();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveDir=" + saveDir));
        }
        return saveDir;
    }

    protected int getMaxSize() {
        Integer maxSize = new Integer(Integer.MAX_VALUE);
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("maxSize=" + maxSize));
        }
        return maxSize;
    }
}

