/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeSingleton;
import webwork.config.Configuration;
import webwork.util.ServletValueStack;
import webwork.view.velocity.WebWorkUtil;

public class VelocityHelper {
    private static final Log log = LogFactory.getLog(VelocityHelper.class);
    public static final String REQUEST = "req";
    public static final String RESPONSE = "res";
    public static final String ACTION = "action";
    static final String WEBWORK_UTIL = "webwork";
    private static boolean initialized = false;
    public static final String VELO_CONTEXT = "__webwork__velocity__context";
    private static final Object INIT_MUTEX = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initVelocity(ServletContext context) throws Exception {
        Object object = INIT_MUTEX;
        synchronized (object) {
            String path;
            final Properties conf = new Properties(){

                public Object get(Object key) {
                    return Configuration.get(key.toString());
                }

                public String getProperty(String key) {
                    return Configuration.getString(key.toString());
                }

                public Enumeration keys() {
                    final Iterator list = Configuration.list();
                    return new Enumeration(){

                        public Object nextElement() {
                            return list.next();
                        }

                        public boolean hasMoreElements() {
                            return list.hasNext();
                        }
                    };
                }
            };
            Properties p = new Properties(conf){

                public Enumeration keys() {
                    return conf.keys();
                }
            };
            String log = p.getProperty("runtime.log");
            if (log != null && (log = context.getRealPath(log)) != null) {
                p.setProperty("runtime.log", log);
            }
            if ((path = p.getProperty("file.resource.loader.path")) != null && (path.equals("/") || !path.startsWith("/")) && (path = context.getRealPath(path)) != null) {
                p.setProperty("file.resource.loader.path", path);
            }
            Velocity.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)context);
            Velocity.init((Properties)p);
            initialized = true;
        }
    }

    public static void merge(Context context, String templateName, Writer writer) {
        try {
            Template t = RuntimeSingleton.getTemplate((String)templateName);
            t.merge(context, writer);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Context getContext(ServletContext context, ServletRequest request, ServletResponse response) {
        return VelocityHelper.getContext(context, request, response, Collections.EMPTY_MAP);
    }

    public static Context getContext(ServletContext context, ServletRequest request, ServletResponse response, Map extraContextParams) {
        try {
            VelocityHelper.checkInited(context);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return VelocityHelper.getContextWithoutInit(request, response, extraContextParams);
    }

    public static Context getContextWithoutInit(ServletRequest request, ServletResponse response, Map extraContextParams) {
        WebWorkVelocityContext ctx = (WebWorkVelocityContext)((Object)request.getAttribute(VELO_CONTEXT));
        if (ctx == null) {
            ctx = new WebWorkVelocityContext(ServletValueStack.getStack(request), extraContextParams);
            ctx.put(REQUEST, request);
            ctx.put(RESPONSE, response);
            ctx.put(WEBWORK_UTIL, new WebWorkUtil((Context)ctx));
            ctx.put(ACTION, ServletValueStack.getStack(request).findValue("/"));
            request.setAttribute(VELO_CONTEXT, (Object)ctx);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInited(ServletContext context) throws Exception {
        Object object = INIT_MUTEX;
        synchronized (object) {
            if (!initialized) {
                VelocityHelper.initVelocity(context);
            }
        }
    }

    static class WebWorkVelocityContext
    extends VelocityContext {
        ServletValueStack stack;

        WebWorkVelocityContext(ServletValueStack aStack, Map extraContextParams) {
            super(extraContextParams);
            this.stack = aStack;
        }

        public boolean internalContainsKey(Object key) {
            boolean contains = super.internalContainsKey(key);
            return contains ? true : this.stack.test(key.toString());
        }

        public Object internalGet(String key) {
            return super.internalContainsKey((Object)key) ? super.internalGet(key) : this.getValueFromStack(key);
        }

        private Object getValueFromStack(String key) {
            if (key.startsWith(".literal.")) {
                return null;
            }
            return this.stack.findValue(key);
        }
    }
}

