/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringVariableSubstitutionKit {
    public static String substitue(String input, Map<String, Object> substitutions) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\\{}", true);
        StringBuilder out = new StringBuilder(input.length());
        StringBuilder variableName = new StringBuilder();
        boolean inVar = false;
        boolean inBackSlash = false;
        boolean inVarBackSlash = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (inVar) {
                if (inVarBackSlash) {
                    variableName.append(token);
                    inVarBackSlash = false;
                    continue;
                }
                if ("\\".equals(token)) {
                    inVarBackSlash = true;
                    continue;
                }
                if ("}".equals(token)) {
                    Object value = substitutions.get(variableName.toString());
                    if (value != null) {
                        out.append(value.toString());
                    } else {
                        out.append("{").append((CharSequence)variableName).append("}");
                    }
                    inVar = false;
                    variableName.setLength(0);
                    continue;
                }
                variableName.append(token);
                continue;
            }
            if (inBackSlash) {
                out.append(token);
                inBackSlash = false;
                continue;
            }
            if ("\\".equals(token)) {
                inBackSlash = true;
                continue;
            }
            if ("{".equals(token)) {
                inVar = true;
                continue;
            }
            out.append(token);
        }
        if (inVar) {
            out.append("{");
            out.append((CharSequence)variableName);
            if (inVarBackSlash) {
                out.append("\\");
            }
        }
        return out.toString();
    }
}

