/*
 * Decompiled with CFR 0.152.
 */
package webwork.multipart;

import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.LogFactory;
import webwork.config.Configuration;
import webwork.multipart.MultiPartRequest;

public class PellMultiPartRequest
extends MultiPartRequest {
    private ServletMultipartRequest multi;

    private String getEncoding() {
        try {
            String encoding = Configuration.getString("webwork.i18n.encoding");
            if (encoding != null) {
                return encoding;
            }
        }
        catch (IllegalArgumentException e) {
            LogFactory.getLog(PellMultiPartRequest.class).info((Object)"Could not get encoding property 'webwork.i18n.encoding' for file upload.  Using system default");
        }
        return null;
    }

    public PellMultiPartRequest(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        boolean memoryUpload = false;
        try {
            memoryUpload = "true".equalsIgnoreCase(Configuration.getString("webwork.multipart.uploadToMemory"));
        }
        catch (IllegalArgumentException e) {
            LogFactory.getLog(PellMultiPartRequest.class).info((Object)"Could not read webwork.multipart.uploadToMemory property for file upload. Defaulting to false");
        }
        this.multi = memoryUpload ? new ServletMultipartRequest((ServletRequest)servletRequest, maxSize, 101, this.getEncoding()) : new ServletMultipartRequest((ServletRequest)servletRequest, saveDir, maxSize, 101, this.getEncoding());
    }

    public Enumeration getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public String[] getParameterValues(String name) {
        Enumeration e = this.multi.getURLParameters(name);
        if (!e.hasMoreElements()) {
            return null;
        }
        ArrayList values = new ArrayList();
        while (e.hasMoreElements()) {
            values.add(e.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration getFileNames() {
        return this.multi.getFileParameterNames();
    }

    public String getFilesystemName(String name) {
        return this.multi.getBaseFilename(name);
    }

    public String getContentType(String name) {
        return this.multi.getContentType(name);
    }

    public File getFile(String name) {
        return this.multi.getFile(name);
    }

    public InputStream getMemoryFileContents(String name) {
        return this.multi.getFileContents(name);
    }
}

