/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.lang.reflect.Array;
import java.util.List;

public class ArrayWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value, String attributeName, List walkedInstances)
            throws SAXException
    {
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        for (int i = 0; i < Array.getLength(value); i++)
        {
            rootWalker.walk(contentHandler, Array.get(value, i), "item", walkedInstances);
        }
        contentHandler.endElement("", attributeName, "");
    }

    public final Class getWalkedType()
    {
        return Array.class;
    }
}
