/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * <b>textfield</b> tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class TextFieldTag extends AbstractHTMLComponentTag
{
    // Attributes ----------------------------------------------------
    protected String sizeAttr;
    protected String maxLengthAttr;
    protected String readonlyAttr;
    protected String onkeyupAttr;

    // Public --------------------------------------------------------
    public String getTemplate()
    {
        return "text";
    }

    public void setSize(String aSize)
    {
        this.sizeAttr = aSize;
    }

    public void setMaxlength(String aMaxLength)
    {
        this.maxLengthAttr = aMaxLength;
    }

    public void setReadonly(String readonly)
    {
        this.readonlyAttr = readonly;
    }

    public void setOnkeyup(String onkeyup)
    {
        this.onkeyupAttr = onkeyup;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (sizeAttr != null)
        {
            this.addParameter("size", findValue(sizeAttr));
        }
        if (maxLengthAttr != null)
        {
            this.addParameter("maxlength", findValue(maxLengthAttr));
        }
        if (readonlyAttr != null)
        {
            this.addParameter("readonly", findValue(readonlyAttr));
        }
        if (onkeyupAttr != null)
        {
            this.addParameter("onkeyup", findValue(onkeyupAttr));
        }
        return super.doEndTag();
    }
}

