/*
 * Atlassian Source Code Template.
 * User: mike
 * Created: 3/09/2002 08:56:45
 * Time: 4:32:34 PM
 * CVS Revision: $Revision: 1.1 $
 * Last CVS Commit: $Date: 2002/09/02 23:55:31 $
 * Author of last CVS Commit: $Author: cybermike $
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

public class AbstractHTMLListTag extends AbstractHTMLComponentTag
{
    protected boolean useMap;
    protected String list;
    protected String listKey;
    protected String listValue;

    public void setList(String aList)
    {
        this.list = aList;
    }

    public void setListKey(String aKey)
    {
        this.listKey = aKey;
    }

    public void setListValue(String aValue)
    {
        this.listValue = aValue;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag() throws JspException
    {
        this.addParameter("list", findValue(list));

        if (listValue != null)
        {
            useMap = true;
            this.addParameter("listValue", findValue(listValue));
        }

        if (listKey != null)
        {
            useMap = true;
            this.addParameter("listKey", findValue(listKey));
        }

        if (listKey == null && listValue == null) // defensive programming against tag caching
        {
            useMap = false;
        }

        return super.doEndTag();
    }

    public void release()
    {
        useMap = false;
        super.release();
    }
}
