/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import webwork.util.ServletValueStack;
import webwork.util.BeanUtil;
import webwork.util.FastByteArrayOutputStream;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import java.io.PrintWriter;

/**
 * Base class for tags with bodies.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.12 $
 */
public abstract class WebWorkBodyTagSupport
        extends BodyTagSupport
{
    protected ServletValueStack stack;

    // BodyTagSupport overrides --------------------------------------
    public void setPageContext(PageContext aPageContext)
    {
        super.setPageContext(aPageContext);
        stack = null;
    }

    public void setParent(Tag aTag)
    {
        super.setParent(aTag);
        stack = null;
    }

    // Protected -----------------------------------------------------
    protected ServletValueStack getStack()
    {
        if (stack == null)
        {
            stack = ServletValueStack.getStack(pageContext);
        }
        else
        {
            // Set the pageContext in the stack to make sure that the context
            // is the correct one, since the same stack is used for the whole
            // request, which can mean several different pageContexts
            stack.setContext(pageContext);
        }
        return stack;
    }

    protected Object findValue(String aName)
    {
        return getStack().findValue(aName);
    }

    /**
     * Will return the string value of the object. If the object has a ValidationEditor then its getAsText() will be
     * called which by default calls toString() unless you override it.
     */
    protected String findString(String aName)
    {
        String result = null;

        Object value = getStack().findValue(aName);
        if (value != null)
        {
            result = BeanUtil.toStringValue(value);
        }
        return result;
    }

    protected String toString(Throwable t)
    {
        FastByteArrayOutputStream bout = new FastByteArrayOutputStream();
        PrintWriter wrt = new PrintWriter(bout);
        t.printStackTrace(wrt);
        wrt.close();
        return bout.toString();
    }

    public int doEndTag() throws JspException
    {
        stack = null;
        return super.doEndTag();
    }

    public void release()
    {
        stack = null;
    }
}
