/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 1.8 $
 */
public class ElseTag
        extends TagSupport
{
    // BodyTag implementation ---------------------------------------
    public int doStartTag() throws JspException
    {
        Boolean ifResult = getId() == null ?
                (Boolean) pageContext.getAttribute(IfTag.ANSWER) :
                (Boolean) pageContext.getAttribute(getId());

        pageContext.removeAttribute(IfTag.ANSWER);

        if (ifResult == null || ifResult.booleanValue() == true)
        {
            return SKIP_BODY;
        }
        else
        {
            return EVAL_BODY_INCLUDE;
        }
    }

    public int doEndTag() throws JspException
    {
        return super.doEndTag();
    }

    public void release()
    {
        setId(null);
        super.release();
    }
}



