/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;


/**
 * This tag will capture the body text and place it into the PageContext using its id as the attribute key
 */
public class DeclareTag extends PropertyTag
{
    @Override
    protected void onOutput(final JspWriter out, final String bodyOutput) throws IOException
    {
        if (getId() != null)
        {
            pageContext.setAttribute(getId(), bodyOutput, PageContext.PAGE_SCOPE);
        }
    }
}