/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

/**
 * This exception can be thrown by property editors instead of IllegalArgumentException ActionSupport will use the
 * bundleKey to look up a localized error message. The message will then be formatted with the propertyValues. If no
 * default message is supplied then one is constructed here. The default message is used to be backwards compatible so
 * that people who have created their own ActionSupport classes and do not want to use the new localization features
 * will not have to make changes to their code.
 *
 * @author Dick Zetterberg (dick@transitor.se)
 * @version $Revision: 1.1 $
 * @see webwork.action.IllegalArgumentAware
 * @see webwork.action.ActionSupport
 */
public class PropertyEditorException extends java.lang.IllegalArgumentException
{
    String message;
    String bundleKey;
    Object[] propertyValues;

    public PropertyEditorException(String bundleKey, Object oneValue)
    {
        this(bundleKey, oneValue, null);
    }

    public PropertyEditorException(String bundleKey, Object oneValue, String defaultMessage)
    {
        this(bundleKey, new Object[] { oneValue }, defaultMessage);
    }

    public PropertyEditorException(String bundleKey, Object[] propertyValues, String defaultMessage)
    {
        this.bundleKey = bundleKey;
        this.propertyValues = propertyValues;
        // If there is no default message then we add one now
        if (defaultMessage == null)
        {
            defaultMessage = "Unable to set value for ";
            if (propertyValues != null && propertyValues.length > 0)
            {
                defaultMessage += propertyValues[0];
            }
        }
        this.message = defaultMessage;
    }

    public String getMessage()
    {
        return message;
    }

    public String getBundleKey()
    {
        return bundleKey;
    }

    public Object[] getPropertyValues()
    {
        return propertyValues;
    }
}