package webwork.interceptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import webwork.action.Action;

/**
 * TODO: Document this class / interface here
 *
 * @since v4.2
 */
public class DefaultInterceptorChain implements InterceptorChain
{
    private final Action action;
    private final Iterator<Interceptor> iterator;

    public DefaultInterceptorChain(Action action, Interceptor...interceptors)
    {
        this(action, Arrays.asList(interceptors));
    }

    public DefaultInterceptorChain(Action action, List<Interceptor> iteratorList)
    {
        this.iterator = iteratorList == null ? Collections.<Interceptor>emptyList().iterator() : iteratorList.iterator();
        this.action = action;
    }

    public String proceed() throws Exception
    {
        if (iterator.hasNext())
        {
            return iterator.next().intercept(this);
        }
        else
        {
            return action.execute();
        }
    }
}
