/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;

import webwork.action.ValidationEditorSupport;

/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.3 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 */
public class SsnEditor extends ValidationEditorSupport
{

    public void setAsText(String txt)
    {
        // Validate sosial security number
        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Birth number must be specified");
        }
        else if (txt.length() != 11)
        {
            throw new IllegalArgumentException("Norwegian sosial security number must be 11 digits");
        }

        try
        {
            Long ssn = Long.decode(txt);
        }
        catch (NumberFormatException nfe)
        {
            throw new IllegalArgumentException("No characters or special signs, only digits allowed");
        }

        if (!Validator.checkSsn(txt))
        {
            throw new IllegalArgumentException("This is not valid Norwegian social security number");
        }

        setValue(txt);
    }
}

