/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;

import webwork.action.ValidationEditorSupport;

/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.3 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 */
public class NameEditor extends ValidationEditorSupport
{

    public void setAsText(String txt)
    {
        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Name must be specified");
        }

        if (txt.length() > 30)
        {
            throw new IllegalArgumentException("Maximum of 30 alphabetic characters");
        }

        setValue(txt);
    }
}

