/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.tutorial;

import webwork.action.Action;
import webwork.action.ActionSupport;

/**
 * Minimal Action implementation
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class HelloAction
        extends ActionSupport
        implements Action
{
    // Attributes ----------------------------------------------------
    String name = "World";

    String greeting;

    // Public --------------------------------------------------------
    public void setName(String name)
    {
        this.name = name;
    }

    public String getGreeting()
    {
        return greeting;
    }

    // Action implementation -----------------------------------------
    protected String doExecute()
            throws Exception
    {
        greeting = "Hello " + name + "!";
        return SUCCESS;
    }
}
