/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.bank;

import webwork.action.ValidationEditorSupport;

/**
 * This code is an adaptation of the Struts example from the JavaWorld article by Thor Kristmundsson.
 * http://www.javaworld.com/javaworld/jw-12-2000/jw-1201-struts_p.html
 */
public class AccountEditor
        extends ValidationEditorSupport
{
    public void setAsText(String txt)
    {
        // Validate account
        if (txt.length() > 9 || txt.length() < 7)
        {
            throw new IllegalArgumentException("Account name must have 7 to 9 digits");
        }

        setValue(txt);
    }
}