/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.*;

/**
 * A simple form
 *
 * @author Rickard \u00D6berg (<email>)
 * @version $Revision: 1.9 $
 * @see <related>
 */
public class FormTest
        extends ActionSupport
        implements CommandDriven
{
    String user = "";
    String password = "";
    String age = "0";
    int year = 1975;
    String author = "";
    String country = "USA";
    boolean male;
    boolean additionalInfo;
    String comments = "";
    String[] interests;
    String[] defaultInterests = { "climbing", "diving", "curling" };
    Preference[] preferences = { new Preference(), new Preference(), new Preference() };

    // Public --------------------------------------------------------
    public String[] getInterests()
    {
        return interests;
    }

    public Preference[] getPreferences()
    {
        return preferences;
    }

    public void setPreferences(Preference[] preferences)
    {
        this.preferences = preferences;
    }

    public void setInterests(String[] interests)
    {
        this.interests = interests;
    }

    public String[] getDefaultInterests()
    {
        return defaultInterests;
    }

    public void setUser(String user)
    {
        if ("".equals(user))
        {
            throw new IllegalArgumentException(getText("missing_name"));
        }
        this.user = user;
    }

    public String getUser()
    {
        return user;
    }

    public void setPassword(String password)
    {
        if ("".equals(password))
        {
            throw new IllegalArgumentException("Please enter your password.");
        }
        this.password = password;
    }

    public String getPassword()
    {
        return password;
    }

    public void setAge(String age)
    {
        if ("0-10".equals(age))
        {
            throw new IllegalArgumentException("Your age must be greater than 10.");
        }
        this.age = age;
    }

    public String getAge()
    {
        return age;
    }

    public void setBirthYear(int year)
    {
        this.year = year;
    }

    public int getBirthYear()
    {
        return year;
    }

    public void setCountry(String country)
    {
        if ("ch".equals(country))
        {
            throw new IllegalArgumentException("Wrong country.  Please try again.");
        }
        this.country = country;
    }

    public String getCountry()
    {
        return country;
    }

    public void setAuth(String author)
    {
        this.author = author;
    }

    public String getAuth()
    {
        return author;
    }

    public void setMale(boolean male)
    {
        this.male = male;
    }

    public boolean getMale()
    {
        return male;
    }

    public void setAdditionalInfo(boolean additionalInfo)
    {
        if (additionalInfo != true)
        {
            throw new IllegalArgumentException("You must accept the additional information to continue.");
        }
        this.additionalInfo = additionalInfo;
    }

    public boolean getAdditionalInfo()
    {
        return additionalInfo;
    }

    public void setComments(String comments)
    {
        this.comments = comments;
    }

    public String getComments()
    {
        return comments;
    }

    // Action implementation -----------------------------------------
    protected String doExecute()
            throws Exception
    {
        // Process data
        return SUCCESS;
    }

    public class Preference
    {
        String pref = "";

        public String getPref()
        {
            return pref;
        }

        public void setPref(String pref)
        {
            this.pref = pref;
        }
    }
}
