package webwork.config.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * An implementation of {@link webwork.config.util.ActionInfo}
 *
 * @since v4.0
 */
class ActionInfoImpl implements ActionInfo
{
    private final String actionName;
    private final String actionAlias;
    private final Map<String, String> attributes;

    ActionInfoImpl(final String actionName, final String actionAlias, Map<String,String> attributeMap)
    {
        this.actionName = actionName;
        this.actionAlias = actionAlias;
        this.attributes = attributeMap;
    }

    public String getActionName()
    {
        return actionName;
    }

    public String getActionAlias()
    {
        return actionAlias;
    }

    public List<String> getAttributeNames()
    {
        return new ArrayList<String>(attributes.keySet());
    }

    public String getAttributeValue(final String attributeName)
    {
        return attributes.get(attributeName);
    }
}
