/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

/**
 * This marker interface should be implemented by actions that do not want any parameters set on them automatically (by
 * the ParametersActionFactoryProxy) This may be useful if one is using the action tag and want to supply the parameters
 * to the action manually using the param tag. It may also be useful if one for security reasons wants to make sure that
 * parameters cannot be set by malicious users.
 *
 * @author Dick Zetterberg (dick@transitor.se)
 * @version $Revision: 1.1 $, $Date: 2003/11/13 21:43:04 $
 */
public interface NoParameters
{
}
