/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.ViewGroup;
import java.util.List;
import nu.annat.beholder.ActionHandler;
import nu.annat.beholder.ComponentFactory;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.presenter.ComponentInfo;

public class BeholderAdapter
extends RecyclerView.Adapter<ComponentViewHolder> {
    private static final String TAG = BeholderAdapter.class.getSimpleName();
    private final ActionHandler actionHandler;
    private final List<ComponentInfo> items;
    private ComponentFactory factory;
    private SparseArray<ComponentInfo> cachedPresenters = new SparseArray();

    public BeholderAdapter(ComponentFactory factory, List<ComponentInfo> items, ActionHandler actionHandler) {
        this.factory = factory;
        this.items = items;
        this.actionHandler = actionHandler;
    }

    public ComponentViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.factory.createReusable((ComponentInfo)this.cachedPresenters.get(viewType), parent, this.actionHandler);
    }

    public int getItemViewType(int position) {
        ComponentInfo componentInfo = this.items.get(position);
        int deepLayoutHash = componentInfo.deepLayoutHash();
        this.cachedPresenters.put(deepLayoutHash, (Object)componentInfo);
        return deepLayoutHash;
    }

    public void onBindViewHolder(ComponentViewHolder holder, int position) {
        this.factory.bindDeep(holder, this.items.get(position), true);
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public void close() {
        this.factory = null;
    }
}

