/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.annat.beholder.ActionHandler;
import nu.annat.beholder.ComponentGroup;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.presenter.ParentPresenter;
import nu.annat.beholder.presenter.Presenter;

public abstract class ComponentFactory {
    private static final String TAG = ComponentFactory.class.getSimpleName();
    protected Map<Class<? extends Presenter>, ComponentInfo> components = new HashMap<Class<? extends Presenter>, ComponentInfo>();

    public void registerComponent(ComponentInfo componentInfo) {
        this.components.put(componentInfo.presenter, componentInfo);
    }

    public void registerComponents(ComponentInfo ... componentInfos) {
        for (ComponentInfo componentInfo : componentInfos) {
            this.registerComponent(componentInfo);
        }
    }

    public ComponentViewHolder createDeep(int order, Class<? extends Presenter> presenterClass, Presenter presenter, ViewGroup root, boolean force, boolean bind, ActionHandler actionHandler) {
        ComponentViewHolder holder = this.createView(order, presenterClass, presenter, root, actionHandler);
        if (bind) {
            holder.setData(presenter, force);
        }
        if (presenter instanceof ParentPresenter && holder instanceof ComponentGroup) {
            ParentPresenter parentPresenter = (ParentPresenter)presenter;
            ViewGroup contentGroup = ((ComponentGroup)((Object)holder)).getChildArea();
            int childOrder = 0;
            for (Presenter component : parentPresenter) {
                ComponentViewHolder deep = this.createDeep(childOrder++, component.getClass(), component, contentGroup, force, true, actionHandler);
                holder.addChild(deep);
                contentGroup.addView(deep.itemView);
            }
        }
        return holder;
    }

    protected ComponentViewHolder createView(int order, Class<? extends Presenter> presenterClass, Presenter presenter, ViewGroup root, ActionHandler actionHandler) {
        ComponentInfo it = this.getIt(presenterClass);
        int layoutId = presenter.layoutHash();
        int reuseId = presenter.deepLayoutHash();
        if (it == null) {
            throw new RuntimeException("Can't find data for " + presenterClass.getName());
        }
        LayoutInflater inflater = LayoutInflater.from((Context)root.getContext());
        ViewDataBinding inflate = DataBindingUtil.inflate((LayoutInflater)inflater, (int)it.layout, (ViewGroup)root, (boolean)false);
        if (inflate == null) {
            throw new RuntimeException("Can't inflate view for " + presenterClass.getName());
        }
        ViewInformation viewInformation = new ViewInformation(order);
        try {
            Constructor<? extends ComponentViewHolder> constructor = it.viewHolder.getConstructor(ViewInformation.class, ActionHandler.class, Integer.TYPE, Integer.TYPE);
            return constructor.newInstance(new Object[]{viewInformation, actionHandler, layoutId, reuseId});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void bindDeep(ComponentViewHolder holder, Presenter presenter, boolean force) {
        Log.d((String)TAG, (String)String.format("holder = %d, presenter = %d", holder.getLayoutId(), presenter.layoutHash()));
        if (holder.getReuseId() != presenter.deepLayoutHash()) {
            throw new RuntimeException(String.format("Presenter does not fit the layout, holder = %d, presenter = %d", holder.getLayoutId(), presenter.layoutHash()));
        }
        holder.setData(presenter, force);
        if (presenter instanceof ParentPresenter && holder instanceof ComponentGroup) {
            ParentPresenter parentPresenter = (ParentPresenter)presenter;
            ViewGroup contentGroup = ((ComponentGroup)((Object)holder)).getChildArea();
            if (holder.getLayoutId() == presenter.layoutHash()) {
                List<ComponentViewHolder> children = holder.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    this.bindDeep(children.get(i), (Presenter)parentPresenter.get(i), force);
                }
            }
        }
    }

    protected ComponentInfo getIt(Class<? extends Presenter> presenterClass) {
        ComponentInfo componentInfo = this.components.get(presenterClass);
        return componentInfo;
    }

    public <T extends ComponentViewHolder> T create(Presenter presenter, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, presenter.getClass(), presenter, root, false, true, actionHandler));
    }

    public <T extends ComponentViewHolder> T createReusable(Presenter presenter, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, presenter.getClass(), presenter, root, false, false, actionHandler));
    }

    public <T extends ComponentViewHolder> T createReusable(Class<? extends Presenter> presenterClass, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, presenterClass, null, root, false, false, actionHandler));
    }

    protected static class ComponentInfo {
        public Class<? extends ComponentViewHolder> viewHolder;
        public int layout;
        public Class<? extends Presenter> presenter;

        public ComponentInfo(Class<? extends ComponentViewHolder> viewHolder, int layout, Class<? extends Presenter> presenter) {
            this.layout = layout;
            this.presenter = presenter;
            this.viewHolder = viewHolder;
        }
    }
}

