/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.http;

import android.content.Context;
import android.location.Location;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.gson.Gson;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.data.android.LastLocationProvider;
import network.path.mobilenode.library.data.android.NetworkMonitor;
import network.path.mobilenode.library.data.http.PathHttpEngine;
import network.path.mobilenode.library.data.http.PathService;
import network.path.mobilenode.library.data.http.PathServiceImpl;
import network.path.mobilenode.library.domain.DomainGenerator;
import network.path.mobilenode.library.domain.PathEngine;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.CheckIn;
import network.path.mobilenode.library.domain.entity.ConnectionStatus;
import network.path.mobilenode.library.domain.entity.JobExecutionId;
import network.path.mobilenode.library.domain.entity.JobList;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.WifiSetting;
import network.path.mobilenode.library.utils.CustomThreadPoolManager;
import network.path.mobilenode.library.utils.Executable;
import network.path.mobilenode.library.utils.GuardedProcessPool;
import network.path.mobilenode.library.utils.SocketExtensionsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.HttpException;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0001aB=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020'H\u0016J\b\u0010=\u001a\u00020>H\u0002J+\u0010?\u001a\u0004\u0018\u0001H@\"\u0004\b\u0000\u0010@2\u0014\u0010A\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H@\u0018\u00010C0BH\u0002\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0017H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u00020\u0017H\u0016J\u0010\u0010L\u001a\u00020G2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020G2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010P\u001a\u00020G2\u0006\u0010Q\u001a\u00020\u0016H\u0002J\u0010\u0010R\u001a\u00020G2\u0006\u0010S\u001a\u00020\u001fH\u0002J\u0010\u0010T\u001a\u00020G2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\u00172\u0006\u0010<\u001a\u00020'H\u0016J\b\u0010X\u001a\u00020GH\u0016J\b\u0010Y\u001a\u00020GH\u0002J\b\u0010Z\u001a\u00020GH\u0016J\b\u0010[\u001a\u00020GH\u0002J\b\u0010\\\u001a\u00020GH\u0016J\u001c\u0010]\u001a\u00020^*\u00020^2\u0006\u0010_\u001a\u00020\u00162\u0006\u0010`\u001a\u000200H\u0002R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001f@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010%\u001a&\u0012\f\u0012\n (*\u0004\u0018\u00010'0' (*\u0012\u0012\f\u0012\n (*\u0004\u0018\u00010'0'\u0018\u00010)0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010*\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u0002042\u0006\u0010\u001a\u001a\u000204@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathHttpEngine;", "Lnetwork/path/mobilenode/library/domain/PathEngine;", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "context", "Landroid/content/Context;", "lastLocationProvider", "Lnetwork/path/mobilenode/library/data/android/LastLocationProvider;", "networkMonitor", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;", "okHttpClient", "Lokhttp3/OkHttpClient;", "gson", "Lcom/google/gson/Gson;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "threadManager", "Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;", "(Landroid/content/Context;Lnetwork/path/mobilenode/library/data/android/LastLocationProvider;Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;Lokhttp3/OkHttpClient;Lcom/google/gson/Gson;Lnetwork/path/mobilenode/library/domain/PathStorage;Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;)V", "checkInTask", "Ljava/util/concurrent/Future;", "currentExecutionUuids", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "httpService", "Lnetwork/path/mobilenode/library/data/http/PathService;", "value", "isRunning", "()Z", "setRunning", "(Z)V", "Lnetwork/path/mobilenode/library/domain/entity/JobList;", "jobList", "getJobList", "()Lnetwork/path/mobilenode/library/domain/entity/JobList;", "setJobList", "(Lnetwork/path/mobilenode/library/domain/entity/JobList;)V", "listeners", "", "Lnetwork/path/mobilenode/library/domain/PathEngine$Listener;", "kotlin.jvm.PlatformType", "", "nodeId", "getNodeId", "()Ljava/lang/String;", "setNodeId", "(Ljava/lang/String;)V", "retryCounter", "", "simpleObfs", "Lnetwork/path/mobilenode/library/utils/GuardedProcessPool;", "ssLocal", "Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "status", "getStatus", "()Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "setStatus", "(Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;)V", "useProxy", "addListener", "l", "createCheckInMessage", "Lnetwork/path/mobilenode/library/domain/entity/CheckIn;", "executeServiceCall", "T", "call", "Lkotlin/Function0;", "Lretrofit2/Call;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getHttpService", "notifyRequest", "", "request", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "onStatusChanged", "connected", "performCheckIn", "delay", "", "pollJobs", "processJob", "executionUuid", "processJobs", "list", "processResult", "result", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "removeListener", "start", "startNativeProcesses", "stop", "test", "toggle", "addProxy", "Lokhttp3/OkHttpClient$Builder;", "host", "port", "Companion", "library_release"})
public final class PathHttpEngine
implements PathEngine,
NetworkMonitor.Listener {
    private final Set<PathEngine.Listener> listeners;
    private final ConcurrentHashMap<String, Boolean> currentExecutionUuids;
    private int retryCounter;
    private boolean useProxy;
    private PathService httpService;
    private Future<?> checkInTask;
    private final GuardedProcessPool ssLocal;
    private final GuardedProcessPool simpleObfs;
    @NotNull
    private ConnectionStatus status;
    @Nullable
    private String nodeId;
    @Nullable
    private JobList jobList;
    private boolean isRunning;
    private final Context context;
    private final LastLocationProvider lastLocationProvider;
    private final NetworkMonitor networkMonitor;
    private final OkHttpClient okHttpClient;
    private final Gson gson;
    private final PathStorage storage;
    private final CustomThreadPoolManager threadManager;
    private static final long HEARTBEAT_INTERVAL_MS = 30000L;
    private static final long HEARTBEAT_INTERVAL_ERROR_MS = 5000L;
    private static final long POLL_INTERVAL_MS = 9000L;
    private static final int MAX_JOBS = 10;
    private static final int MAX_RETRIES = 5;
    private static final int TIMEOUT = 600;
    private static final long PROXY_RESTART_TIMEOUT = 3600000L;
    private static final int PROXY_PORT = 443;
    private static final String PROXY_PASSWORD = "PathNetwork";
    private static final String PROXY_ENCRYPTION_METHOD = "aes-256-cfb";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConnectionStatus getStatus() {
        return this.status;
    }

    private void setStatus(ConnectionStatus value) {
        this.status = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onStatusChanged(value);
        }
    }

    @Override
    @Nullable
    public String getNodeId() {
        return this.nodeId;
    }

    private void setNodeId(String value) {
        this.nodeId = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onNodeId(value);
        }
    }

    @Override
    @Nullable
    public JobList getJobList() {
        return this.jobList;
    }

    private void setJobList(JobList value) {
        this.jobList = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onJobListReceived(value);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private void setRunning(boolean value) {
        this.isRunning = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onRunning(value);
        }
    }

    @Override
    public void start() {
        this.networkMonitor.addListener(this);
        this.httpService = this.getHttpService(false);
        this.performCheckIn(0L);
        this.pollJobs(0L);
    }

    @Override
    public void processResult(@NotNull JobResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (Intrinsics.areEqual((Object)result2.getExecutionUuid(), (Object)"DUMMY_UUID")) {
            return;
        }
        String string = this.storage.getNodeId();
        if (string == null) {
            return;
        }
        String nodeId = string;
        CustomThreadPoolManager.run$default(this.threadManager, "processResult", 0L, (Function0)new Function0<Unit>(this, nodeId, result2){
            final /* synthetic */ PathHttpEngine this$0;
            final /* synthetic */ String $nodeId;
            final /* synthetic */ JobResult $result;

            public final void invoke() {
                PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<Unit>>(this){
                    final /* synthetic */ processResult.1 this$0;

                    @Nullable
                    public final Call<Unit> invoke() {
                        PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                        return pathService != null ? pathService.postResult(this.this$0.$nodeId, this.this$0.$result.getExecutionUuid(), this.this$0.$result) : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0).remove(this.$result.getExecutionUuid());
                Map $receiver$iv = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                Map map = $receiver$iv;
                for (Map.Entry<K, V> entry$iv : map.entrySet()) {
                    boolean it = (Boolean)entry$iv.getValue();
                    if (!(!it)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map inactiveUuids = result$iv;
                Timber.d((String)("HTTP: " + PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0).size() + " jobs in the pool, " + inactiveUuids.size() + " jobs not yet active..."), (Object[])new Object[0]);
            }
            {
                this.this$0 = pathHttpEngine;
                this.$nodeId = string;
                this.$result = jobResult;
                super(0);
            }
        }, 2, null);
    }

    @Override
    public void stop() {
        this.threadManager.stop();
        Executable.INSTANCE.killAll(this.context);
        this.networkMonitor.removeListener(this);
        this.setStatus(ConnectionStatus.LOOKING);
        this.setJobList(null);
        this.setRunning(true);
    }

    @Override
    public void toggle() {
        this.setRunning(!this.isRunning());
        Timber.d((String)("HTTP: changed status to [" + this.isRunning() + ']'), (Object[])new Object[0]);
    }

    @Override
    public boolean addListener(@NotNull PathEngine.Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.add(l);
    }

    @Override
    public boolean removeListener(@NotNull PathEngine.Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.remove(l);
    }

    @Override
    public void onStatusChanged(boolean connected) {
        if (connected) {
            this.performCheckIn(500L);
        }
    }

    private final void performCheckIn(long delay) {
        Future<?> future = this.checkInTask;
        if (future != null) {
            future.cancel(true);
        }
        this.checkInTask = this.threadManager.run("checkIn", delay, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                Timber.d((String)"HTTP: Checking in...", (Object[])new Object[0]);
                JobList result2 = (JobList)PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<JobList>>(this){
                    final /* synthetic */ performCheckIn.1 this$0;

                    @Nullable
                    public final Call<JobList> invoke() {
                        Call<JobList> call;
                        PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                        if (pathService != null) {
                            String string = PathHttpEngine.access$getStorage$p(this.this$0.this$0).getNodeId();
                            if (string == null) {
                                string = "";
                            }
                            call = pathService.checkIn(string, PathHttpEngine.access$createCheckInMessage(this.this$0.this$0));
                        } else {
                            call = null;
                        }
                        return call;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                if (result2 != null) {
                    PathHttpEngine.access$processJobs(this.this$0, result2);
                } else if (this.this$0.getStatus() != ConnectionStatus.LOOKING) {
                    PathHttpEngine.access$setStatus$p(this.this$0, ConnectionStatus.DISCONNECTED);
                }
                Timber.d((String)"HTTP: Scheduling check in...", (Object[])new Object[0]);
                long nextDelay = PathHttpEngine.access$getRetryCounter$p(this.this$0) > 0 ? 5000L : 30000L;
                PathHttpEngine.access$performCheckIn(this.this$0, nextDelay);
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void processJobs(JobList list) {
        Timber.d((String)("HTTP: received job list [" + list + ']'), (Object[])new Object[0]);
        if (list.getNodeId() != null) {
            this.setNodeId(list.getNodeId());
        }
        this.setJobList(list);
        this.setStatus(this.useProxy ? ConnectionStatus.PROXY : ConnectionStatus.CONNECTED);
        Collection collection = list.getJobs();
        if (!collection.isEmpty()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list.getJobs();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JobExecutionId jobExecutionId = (JobExecutionId)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getExecutionUuid(), (Object)false);
                collection2.add(pair);
            }
            List ids = (List)destination$iv$iv;
            MapsKt.putAll((Map)this.currentExecutionUuids, (Iterable)ids);
        }
    }

    private final void pollJobs(long delay) {
        this.threadManager.run("pollJobs", delay, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                Timber.d((String)"HTTP: Start processing jobs...", (Object[])new Object[0]);
                Map map = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                if (!map.isEmpty()) {
                    Object $receiver$iv = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    Map map2 = $receiver$iv;
                    for (Map.Entry<K, V> entry$iv : map2.entrySet()) {
                        boolean it = (Boolean)entry$iv.getValue();
                        if (!(!it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    List ids = CollectionsKt.toList((Iterable)((Map)result$iv).keySet());
                    Timber.d((String)("HTTP: " + ids.size() + " jobs to be processed"), (Object[])new Object[0]);
                    $receiver$iv = ids;
                    Iterator<T> iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv = iterator.next();
                        String it = (String)element$iv;
                        PathHttpEngine.access$processJob(this.this$0, it);
                    }
                }
                Timber.d((String)"HTTP: Scheduling next jobs processing cycle...", (Object[])new Object[0]);
                PathHttpEngine.access$pollJobs(this.this$0, 9000L);
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    private final void processJob(String executionUuid) {
        CustomThreadPoolManager.run$default(this.threadManager, "processJob", 0L, (Function0)new Function0<Object>(this, executionUuid){
            final /* synthetic */ PathHttpEngine this$0;
            final /* synthetic */ String $executionUuid;

            @Nullable
            public final Object invoke() {
                Object object;
                JobRequest details2 = (JobRequest)PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<JobRequest>>(this){
                    final /* synthetic */ processJob.1 this$0;

                    @Nullable
                    public final Call<JobRequest> invoke() {
                        PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                        return pathService != null ? pathService.requestDetails(this.this$0.$executionUuid) : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                if (details2 != null) {
                    details2.setExecutionUuid(this.$executionUuid);
                    Map map = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                    String string = this.$executionUuid;
                    Boolean bl = true;
                    map.put(string, bl);
                    PathHttpEngine.access$notifyRequest(this.this$0, details2);
                    object = Unit.INSTANCE;
                } else {
                    object = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0).remove(this.$executionUuid);
                }
                return object;
            }
            {
                this.this$0 = pathHttpEngine;
                this.$executionUuid = string;
                super(0);
            }
        }, 2, null);
    }

    private final void notifyRequest(JobRequest request) {
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onRequestReceived(request);
        }
    }

    private final CheckIn createCheckInMessage() {
        Object object;
        int n;
        Location location;
        try {
            location = this.lastLocationProvider.location();
        }
        catch (Exception e) {
            location = null;
        }
        Location location2 = location;
        boolean requestJobs = true;
        if (this.storage.getWifiSetting() == WifiSetting.WIFI_ONLY) {
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities capabilities;
                Network network = this.networkMonitor.getConnectivityManager().getActiveNetwork();
                NetworkCapabilities networkCapabilities = capabilities = this.networkMonitor.getConnectivityManager().getNetworkCapabilities(network);
                requestJobs = networkCapabilities != null && networkCapabilities.hasTransport(1);
                Timber.d((String)("HTTP: network [" + network + "], setting [" + (Object)((Object)this.storage.getWifiSetting()) + ", requestJobs = " + requestJobs), (Object[])new Object[0]);
            } else {
                NetworkInfo networkInfo;
                NetworkInfo networkInfo2 = networkInfo = this.networkMonitor.getConnectivityManager().getNetworkInfo(1);
                requestJobs = networkInfo2 != null && networkInfo2.isConnected();
                Timber.d((String)("HTTP: network info [" + networkInfo + "], setting [" + (Object)((Object)this.storage.getWifiSetting()) + "], requestJobs = " + requestJobs), (Object[])new Object[0]);
            }
        }
        if (this.isRunning() && requestJobs) {
            int n2 = 10 - this.currentExecutionUuids.size();
            int n3 = 0;
            n = Math.max(n2, n3);
        } else {
            n = 0;
        }
        int jobsToRequest = n;
        String string = this.storage.getNodeId();
        String string2 = this.storage.getWalletAddress();
        Object object2 = location2;
        if (object2 == null || (object2 = String.valueOf(object2.getLatitude())) == null) {
            object2 = "0.0";
        }
        if ((object = location2) == null || (object = String.valueOf(object.getLongitude())) == null) {
            object = "0.0";
        }
        int n4 = jobsToRequest;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object3 = object;
        Object object4 = object2;
        String string6 = string2;
        return new CheckIn(null, string, (String)object4, (String)object3, string6, string5, string4, string3, n4, 225, null);
    }

    private final <T> T executeServiceCall(Function0<? extends Call<T>> call) {
        Object var2_2;
        try {
            Object result2;
            Call call2 = (Call)call.invoke();
            Object object = call2 != null && (call2 = call2.execute()) != null ? call2.body() : (result2 = null);
            if (result2 != null) {
                this.retryCounter = 0;
            }
        }
        catch (Exception e) {
            boolean fallback = true;
            Exception exception = e;
            if (exception instanceof UnknownHostException) {
                fallback = false;
            } else if (exception instanceof HttpException && ((HttpException)e).code() == 422) {
                Object body = ((HttpException)e).response().body();
                Timber.w((String)("HTTP exception: " + body), (Object[])new Object[0]);
                fallback = false;
            }
            if (fallback) {
                PathHttpEngine pathHttpEngine = this;
                ++pathHttpEngine.retryCounter;
                if (pathHttpEngine.retryCounter >= 5) {
                    Timber.w((String)("HTTP: switching proxy mode to [" + !this.useProxy + ']'), (Object[])new Object[0]);
                    this.retryCounter = 0;
                    this.httpService = this.getHttpService(!this.useProxy);
                }
            }
            Timber.w((String)("HTTP: Service call exception: " + e), (Object[])new Object[0]);
            var2_2 = null;
        }
        return var2_2;
    }

    private final PathService getHttpService(boolean useProxy) {
        OkHttpClient client;
        OkHttpClient okHttpClient;
        String host = "127.0.0.1";
        int port = Constants.INSTANCE.getSS_LOCAL_PORT();
        Timber.d((String)("HTTP: creating new service [" + useProxy + "]..."), (Object[])new Object[0]);
        if (useProxy) {
            this.startNativeProcesses();
        }
        if (useProxy && SocketExtensionsKt.isPortInUse(port)) {
            Timber.d((String)("HTTP: proxy port [" + port + "] is in use, connecting"), (Object[])new Object[0]);
            this.useProxy = true;
            OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"okHttpClient.newBuilder()");
            okHttpClient = this.addProxy(builder, host, port).build();
        } else {
            if (useProxy) {
                Timber.d((String)("HTTP: proxy port [" + port + "] is not in use, proxy is not running"), (Object[])new Object[0]);
            } else {
                Timber.d((String)"HTTP: proxy is not required", (Object[])new Object[0]);
            }
            this.useProxy = false;
            okHttpClient = this.okHttpClient;
        }
        OkHttpClient okHttpClient2 = client = okHttpClient;
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient2, (String)"client");
        return new PathServiceImpl(okHttpClient2, this.gson);
    }

    private final void startNativeProcesses() {
        String host = DomainGenerator.INSTANCE.findDomain(this.storage);
        if (host != null) {
            Timber.d((String)("HTTP: found proxy domain [" + host + ']'), (Object[])new Object[0]);
            Executable.INSTANCE.killAll(this.context);
            String libs = this.context.getApplicationInfo().nativeLibraryDir;
            List obfsCmd = CollectionsKt.mutableListOf((Object[])new String[]{new File(libs, "libobfs-local.so").getAbsolutePath(), "-s", host, "-p", String.valueOf(443), "-l", String.valueOf(Constants.INSTANCE.getSIMPLE_OBFS_PORT()), "-t", String.valueOf(600), "--obfs", "http"});
            GuardedProcessPool.start$default(this.simpleObfs, obfsCmd, null, 2, null);
            List cmd = CollectionsKt.mutableListOf((Object[])new String[]{new File(libs, "libss-local.so").getAbsolutePath(), "-u", "-s", "127.0.0.1", "-p", String.valueOf(Constants.INSTANCE.getSIMPLE_OBFS_PORT()), "-k", PROXY_PASSWORD, "-m", PROXY_ENCRYPTION_METHOD, "-b", "127.0.0.1", "-l", String.valueOf(Constants.INSTANCE.getSS_LOCAL_PORT()), "-t", String.valueOf(600)});
            GuardedProcessPool.start$default(this.ssLocal, cmd, null, 2, null);
        } else {
            Timber.w((String)"HTTP: proxy domain not found", (Object[])new Object[0]);
        }
        this.threadManager.run("nativeProcesses", 3600000L, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                PathHttpEngine.access$startNativeProcesses(this.this$0);
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    private final OkHttpClient.Builder addProxy(@NotNull OkHttpClient.Builder $receiver, String host, int port) {
        OkHttpClient.Builder builder = $receiver.proxy(new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(host, port))).addInterceptor((Interceptor)addProxy.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"proxy(Proxy(Proxy.Type.S\u2026())\n                    }");
        return builder;
    }

    private final void test() {
        JobRequest dummyRequest = new JobRequest(null, "", "traceroute", null, "HELLO", "www.google.com", null, null, null, null, null, null, "DUMMY_UUID", "DUMMY_UUID", 4041, null);
        this.notifyRequest(dummyRequest);
    }

    public PathHttpEngine(@NotNull Context context, @NotNull LastLocationProvider lastLocationProvider, @NotNull NetworkMonitor networkMonitor, @NotNull OkHttpClient okHttpClient, @NotNull Gson gson, @NotNull PathStorage storage, @NotNull CustomThreadPoolManager threadManager) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)lastLocationProvider, (String)"lastLocationProvider");
        Intrinsics.checkParameterIsNotNull((Object)networkMonitor, (String)"networkMonitor");
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)threadManager, (String)"threadManager");
        this.context = context;
        this.lastLocationProvider = lastLocationProvider;
        this.networkMonitor = networkMonitor;
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        this.storage = storage;
        this.threadManager = threadManager;
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap(0));
        this.currentExecutionUuids = new ConcurrentHashMap();
        this.ssLocal = new GuardedProcessPool();
        this.simpleObfs = new GuardedProcessPool();
        this.status = ConnectionStatus.LOOKING;
        this.nodeId = this.storage.getNodeId();
        this.isRunning = true;
    }

    @Nullable
    public static final /* synthetic */ Object access$executeServiceCall(PathHttpEngine $this, @NotNull Function0 call) {
        return $this.executeServiceCall(call);
    }

    @Nullable
    public static final /* synthetic */ PathService access$getHttpService$p(PathHttpEngine $this) {
        return $this.httpService;
    }

    public static final /* synthetic */ void access$setHttpService$p(PathHttpEngine $this, @Nullable PathService pathService) {
        $this.httpService = pathService;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getCurrentExecutionUuids$p(PathHttpEngine $this) {
        return $this.currentExecutionUuids;
    }

    @NotNull
    public static final /* synthetic */ PathStorage access$getStorage$p(PathHttpEngine $this) {
        return $this.storage;
    }

    @NotNull
    public static final /* synthetic */ CheckIn access$createCheckInMessage(PathHttpEngine $this) {
        return $this.createCheckInMessage();
    }

    public static final /* synthetic */ void access$processJobs(PathHttpEngine $this, @NotNull JobList list) {
        $this.processJobs(list);
    }

    @NotNull
    public static final /* synthetic */ ConnectionStatus access$getStatus$p(PathHttpEngine $this) {
        return $this.getStatus();
    }

    public static final /* synthetic */ void access$setStatus$p(PathHttpEngine $this, @NotNull ConnectionStatus connectionStatus) {
        $this.setStatus(connectionStatus);
    }

    public static final /* synthetic */ int access$getRetryCounter$p(PathHttpEngine $this) {
        return $this.retryCounter;
    }

    public static final /* synthetic */ void access$setRetryCounter$p(PathHttpEngine $this, int n) {
        $this.retryCounter = n;
    }

    public static final /* synthetic */ void access$performCheckIn(PathHttpEngine $this, long delay) {
        $this.performCheckIn(delay);
    }

    public static final /* synthetic */ void access$processJob(PathHttpEngine $this, @NotNull String executionUuid) {
        $this.processJob(executionUuid);
    }

    public static final /* synthetic */ void access$pollJobs(PathHttpEngine $this, long delay) {
        $this.pollJobs(delay);
    }

    public static final /* synthetic */ void access$notifyRequest(PathHttpEngine $this, @NotNull JobRequest request) {
        $this.notifyRequest(request);
    }

    public static final /* synthetic */ void access$startNativeProcesses(PathHttpEngine $this) {
        $this.startNativeProcesses();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathHttpEngine$Companion;", "", "()V", "HEARTBEAT_INTERVAL_ERROR_MS", "", "HEARTBEAT_INTERVAL_MS", "MAX_JOBS", "", "MAX_RETRIES", "POLL_INTERVAL_MS", "PROXY_ENCRYPTION_METHOD", "", "PROXY_PASSWORD", "PROXY_PORT", "PROXY_RESTART_TIMEOUT", "TIMEOUT", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

