/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import android.content.Context;
import com.google.gson.Gson;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.path.mobilenode.library.data.runner.FallbackRunner;
import network.path.mobilenode.library.data.runner.HttpRunner;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.TcpRunner;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.data.runner.TraceRunner;
import network.path.mobilenode.library.data.runner.UdpRunner;
import network.path.mobilenode.library.domain.PathJobExecutor;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnetwork/path/mobilenode/library/data/runner/PathJobExecutorImpl;", "Lnetwork/path/mobilenode/library/domain/PathJobExecutor;", "okHttpClient", "Lokhttp3/OkHttpClient;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "context", "Landroid/content/Context;", "gson", "Lcom/google/gson/Gson;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "(Lokhttp3/OkHttpClient;Lnetwork/path/mobilenode/library/domain/PathStorage;Landroid/content/Context;Lcom/google/gson/Gson;Lnetwork/path/mobilenode/library/data/runner/TimeSource;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "execute", "Ljava/util/concurrent/Future;", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "request", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "findRunner", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "findRunner$library_release", "start", "", "stop", "library_release"})
public final class PathJobExecutorImpl
implements PathJobExecutor {
    private ExecutorService executor;
    private final OkHttpClient okHttpClient;
    private final PathStorage storage;
    private final Context context;
    private final Gson gson;
    private final TimeSource timeSource;

    @Override
    public void start() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
        this.executor = executorService;
    }

    @Override
    @NotNull
    public Future<JobResult> execute(@NotNull JobRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        Future<JobResult> future = executorService.submit((Callable)new Callable<JobResult>(this, request){
            final /* synthetic */ PathJobExecutorImpl this$0;
            final /* synthetic */ JobRequest $request;

            @NotNull
            public final JobResult call() {
                return this.this$0.findRunner$library_release(this.$request).runJob(this.$request, PathJobExecutorImpl.access$getTimeSource$p(this.this$0));
            }
            {
                this.this$0 = pathJobExecutorImpl;
                this.$request = jobRequest;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(future, (String)"executor.submit(Callable\u2026t, timeSource)\n        })");
        return future;
    }

    @Override
    public void stop() {
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        executorService.shutdown();
    }

    @NotNull
    public final Runner findRunner$library_release(@NotNull JobRequest request) {
        Runner runner;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        JobRequest $receiver = request;
        if ($receiver.getProtocol() == null) {
            runner = FallbackRunner.INSTANCE;
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"http", (boolean)true)) {
            runner = new HttpRunner(this.okHttpClient, this.storage);
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"tcp", (boolean)true)) {
            SocketFactory socketFactory = SocketFactory.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)socketFactory, (String)"SocketFactory.getDefault()");
            runner = new TcpRunner(socketFactory);
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"udp", (boolean)true)) {
            runner = new UdpRunner();
        } else {
            String string = $receiver.getMethod();
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            runner = StringsKt.startsWith((String)string2, (String)"traceroute", (boolean)true) ? (Runner)new TraceRunner(this.context, this.gson) : (Runner)FallbackRunner.INSTANCE;
        }
        return runner;
    }

    public PathJobExecutorImpl(@NotNull OkHttpClient okHttpClient, @NotNull PathStorage storage, @NotNull Context context, @NotNull Gson gson, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        this.okHttpClient = okHttpClient;
        this.storage = storage;
        this.context = context;
        this.gson = gson;
        this.timeSource = timeSource;
    }

    @NotNull
    public static final /* synthetic */ TimeSource access$getTimeSource$p(PathJobExecutorImpl $this) {
        return $this.timeSource;
    }
}

