/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.RunnerUtilsKt;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import network.path.mobilenode.library.utils.SocketExtensionsKt;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnetwork/path/mobilenode/library/data/runner/HttpRunner;", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "okHttpClient", "Lokhttp3/OkHttpClient;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "(Lokhttp3/OkHttpClient;Lnetwork/path/mobilenode/library/domain/PathStorage;)V", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "getJobType", "()Lnetwork/path/mobilenode/library/domain/entity/JobType;", "buildRequest", "Lokhttp3/Request;", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "runHttpJob", "Lkotlin/Pair;", "", "", "runJob", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "Companion", "library_release"})
public final class HttpRunner
implements Runner {
    @NotNull
    private final JobType jobType;
    private final OkHttpClient okHttpClient;
    private final PathStorage storage;
    private static final Regex HTTP_PROTOCOL_REGEX;
    public static final Companion Companion;

    @Override
    @NotNull
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    @NotNull
    public JobResult runJob(@NotNull JobRequest jobRequest, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        return RunnerUtilsKt.computeJobResult(this.getJobType(), jobRequest, timeSource, (Function1<? super JobRequest, Pair<String, Long>>)((Function1)new Function1<JobRequest, Pair<? extends String, ? extends Long>>(this){
            final /* synthetic */ HttpRunner this$0;

            @NotNull
            public final Pair<String, Long> invoke(@NotNull JobRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return HttpRunner.access$runHttpJob(this.this$0, it);
            }
            {
                this.this$0 = httpRunner;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<String, Long> runHttpJob(JobRequest jobRequest) {
        String string;
        Request request = this.buildRequest(jobRequest);
        Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response it;
            Response response = it = (Response)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"it");
            string = SocketExtensionsKt.getBody(response).string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return TuplesKt.to((Object)string, null);
    }

    private final Request buildRequest(JobRequest jobRequest) {
        JobRequest $receiver = jobRequest;
        if ($receiver.getEndpointAddress() == null) {
            throw (Throwable)new IOException("Missing endpoint address in " + jobRequest);
        }
        Regex regex = HTTP_PROTOCOL_REGEX;
        CharSequence charSequence = $receiver.getEndpointAddress();
        String prependedProtocol = regex.matches(charSequence) ? "" : "http://";
        HttpUrl httpUrl = HttpUrl.parse((String)(prependedProtocol + $receiver.getEndpointAddress()));
        if (httpUrl == null) {
            throw (Throwable)new IOException("Unparsable url: " + $receiver.getEndpointAddress());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(\"$prepende\u2026e url: $endpointAddress\")");
        HttpUrl urlPrefix = httpUrl;
        HttpUrl.Builder urlPrefixWithPortBuilder = urlPrefix.newBuilder();
        if ($receiver.getEndpointPort() != null && Constants.INSTANCE.getTCP_UDP_PORT_RANGE().contains($receiver.getEndpointPort().intValue())) {
            urlPrefixWithPortBuilder.port($receiver.getEndpointPort().intValue());
        }
        Object object = $receiver.getEndpointAdditionalParams();
        StringBuilder stringBuilder = new StringBuilder().append(urlPrefixWithPortBuilder.build());
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        Object object3 = object2;
        String completeUrl = stringBuilder.append((String)object3).toString();
        String string = jobRequest.getMethod();
        if (string == null) {
            string = "GET";
        }
        String method = string;
        Request.Builder requestBuilder = new Request.Builder().method(method, null).url(completeUrl);
        boolean hasUserAgent = false;
        List<Map<String, String>> list = jobRequest.getHeaders();
        if (list != null) {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv = list;
            object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            object3 = $receiver$iv$iv.iterator();
            while (object3.hasNext()) {
                Object element$iv$iv = object3.next();
                Map it = (Map)element$iv$iv;
                Iterable list$iv$iv = it.entrySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                if (!Intrinsics.areEqual((Object)((String)entry.getKey()), (Object)"User-Agent")) continue;
                hasUserAgent = true;
            }
        }
        if (!hasUserAgent) {
            String nodeId = this.storage.getNodeId();
            String ua = "Mozilla/5.0 (Path Network 1.0.1; Android; " + System.getProperty("os.arch") + ") 1.0.17/10017 (KHTML, like Gecko) Node/" + nodeId;
            requestBuilder.addHeader("User-Agent", ua);
        }
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    public HttpRunner(@NotNull OkHttpClient okHttpClient, @NotNull PathStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        this.okHttpClient = okHttpClient;
        this.storage = storage;
        this.jobType = JobType.HTTP;
    }

    static {
        Companion = new Companion(null);
        String string = "^https?://.*";
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        HTTP_PROTOCOL_REGEX = new Regex(string, regexOption);
    }

    @NotNull
    public static final /* synthetic */ Pair access$runHttpJob(HttpRunner $this, @NotNull JobRequest jobRequest) {
        return $this.runHttpJob(jobRequest);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnetwork/path/mobilenode/library/data/runner/HttpRunner$Companion;", "", "()V", "HTTP_PROTOCOL_REGEX", "Lkotlin/text/Regex;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

