/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.utils;

import android.content.SharedPreferences;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import network.path.mobilenode.library.utils.PrefsDelegatesKt;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\"\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnetwork/path/mobilenode/library/utils/SharedPreferencesDelegate;", "T", "", "Lkotlin/properties/ReadWriteProperty;", "prefs", "Landroid/content/SharedPreferences;", "name", "", "defaultValue", "(Landroid/content/SharedPreferences;Ljava/lang/String;Ljava/lang/Object;)V", "Ljava/lang/Object;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "library_release"})
public final class SharedPreferencesDelegate<T>
implements ReadWriteProperty<Object, T> {
    private final SharedPreferences prefs;
    private final String name;
    private final T defaultValue;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public T getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        if (!this.prefs.contains(this.name)) {
            Timber.v((String)("Shared preference [" + this.name + "] is missing. Returning default [" + this.defaultValue + ']'), (Object[])new Object[0]);
            t = this.defaultValue;
            return t;
        } else {
            void var3_4;
            Object object;
            T t2 = this.defaultValue;
            if (t2 instanceof Boolean) {
                object = this.prefs.getBoolean(this.name, ((Boolean)this.defaultValue).booleanValue());
            } else if (t2 instanceof Integer) {
                object = this.prefs.getInt(this.name, ((Number)this.defaultValue).intValue());
            } else if (t2 instanceof Long) {
                object = this.prefs.getLong(this.name, ((Number)this.defaultValue).longValue());
            } else if (t2 instanceof Float) {
                object = Float.valueOf(this.prefs.getFloat(this.name, ((Number)this.defaultValue).floatValue()));
            } else if (t2 instanceof String) {
                String string = this.prefs.getString(this.name, (String)this.defaultValue);
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                object = string;
            } else {
                if (!(t2 instanceof Set)) throw (Throwable)new RuntimeException("Bundle value " + this.defaultValue + " has wrong type");
                if (!PrefsDelegatesKt.isSetOf((Set)this.defaultValue)) throw (Throwable)new RuntimeException("Bundle value " + this.defaultValue + " has wrong type");
                T t3 = this.defaultValue;
                if (t3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
                }
                Set set = this.prefs.getStringSet(this.name, (Set)t3);
                if (set == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                object = set;
            }
            Object value = object;
            Timber.v((String)("Found shared preference [" + this.name + "] = [" + value + ']'), (Object[])new Object[0]);
            t = var3_4;
        }
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(@NotNull Object thisRef, @NotNull KProperty<?> property, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Timber.v((String)("Saving new shared preference [" + this.name + "] = [" + value + ']'), (Object[])new Object[0]);
        SharedPreferences.Editor editor = this.prefs.edit();
        T t = value;
        if (t instanceof Boolean) {
            editor.putBoolean(this.name, ((Boolean)value).booleanValue());
        } else if (t instanceof Integer) {
            editor.putInt(this.name, ((Number)value).intValue());
        } else if (t instanceof Long) {
            editor.putLong(this.name, ((Number)value).longValue());
        } else if (t instanceof Float) {
            editor.putFloat(this.name, ((Number)value).floatValue());
        } else if (t instanceof String) {
            editor.putString(this.name, (String)value);
        } else {
            if (!(t instanceof Set)) throw (Throwable)new RuntimeException("Bundle value " + value + " has wrong type");
            if (!PrefsDelegatesKt.isSetOf((Set)value)) throw (Throwable)new RuntimeException("Bundle value " + value + " has wrong type");
            editor.putStringSet(this.name, (Set)value);
        }
        editor.apply();
    }

    public SharedPreferencesDelegate(@NotNull SharedPreferences prefs, @NotNull String name, @NotNull T defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        this.prefs = prefs;
        this.name = name;
        this.defaultValue = defaultValue;
    }
}

