/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.http;

import android.content.Context;
import android.location.Location;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.gson.Gson;
import com.instacart.library.truetime.TrueTime;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.data.android.LastLocationProvider;
import network.path.mobilenode.library.data.android.NetworkMonitor;
import network.path.mobilenode.library.data.http.PathHttpEngine;
import network.path.mobilenode.library.data.http.PathNativeProcessesImpl;
import network.path.mobilenode.library.data.http.PathService;
import network.path.mobilenode.library.data.http.PathServiceImpl;
import network.path.mobilenode.library.domain.PathEngine;
import network.path.mobilenode.library.domain.PathNativeProcesses;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.CheckIn;
import network.path.mobilenode.library.domain.entity.ConnectionStatus;
import network.path.mobilenode.library.domain.entity.JobExecutionId;
import network.path.mobilenode.library.domain.entity.JobList;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.WifiSetting;
import network.path.mobilenode.library.utils.CustomThreadPoolManager;
import network.path.mobilenode.library.utils.SocketExtensionsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.HttpException;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 c2\u00020\u00012\u00020\u0002:\u0001cBE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020(H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0002J+\u0010?\u001a\u0004\u0018\u0001H@\"\u0004\b\u0000\u0010@2\u0014\u0010A\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H@\u0018\u00010C0BH\u0002\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u0012H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020G2\u0006\u0010N\u001a\u00020\u0012H\u0016J\u0010\u0010O\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010P\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010Q\u001a\u00020G2\u0006\u0010R\u001a\u00020\u0018H\u0002J\u0010\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020 H\u0002J\u0010\u0010U\u001a\u00020G2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u00122\u0006\u0010<\u001a\u00020(H\u0016J\b\u0010Y\u001a\u00020GH\u0016J\b\u0010Z\u001a\u00020GH\u0002J\b\u0010[\u001a\u00020GH\u0016J\b\u0010\\\u001a\u00020GH\u0002J\b\u0010]\u001a\u00020GH\u0002J\b\u0010^\u001a\u00020\u0012H\u0016J\u001c\u0010_\u001a\u00020`*\u00020`2\u0006\u0010a\u001a\u00020\u00182\u0006\u0010b\u001a\u000203H\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001b\u001a\u0004\u0018\u00010 @RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010&\u001a&\u0012\f\u0012\n )*\u0004\u0018\u00010(0( )*\u0012\u0012\f\u0012\n )*\u0004\u0018\u00010(0(\u0018\u00010*0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010,\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u0002042\u0006\u0010\u001b\u001a\u000204@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathHttpEngine;", "Lnetwork/path/mobilenode/library/domain/PathEngine;", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "nativeProcesses", "Lnetwork/path/mobilenode/library/domain/PathNativeProcesses;", "lastLocationProvider", "Lnetwork/path/mobilenode/library/data/android/LastLocationProvider;", "networkMonitor", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;", "okHttpClient", "Lokhttp3/OkHttpClient;", "gson", "Lcom/google/gson/Gson;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "threadManager", "Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;", "isTest", "", "(Lnetwork/path/mobilenode/library/domain/PathNativeProcesses;Lnetwork/path/mobilenode/library/data/android/LastLocationProvider;Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;Lokhttp3/OkHttpClient;Lcom/google/gson/Gson;Lnetwork/path/mobilenode/library/domain/PathStorage;Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;Z)V", "checkInTask", "Ljava/util/concurrent/Future;", "currentExecutionUuids", "Ljava/util/concurrent/ConcurrentHashMap;", "", "httpService", "Lnetwork/path/mobilenode/library/data/http/PathService;", "value", "isJobExecutionRunning", "()Z", "setJobExecutionRunning", "(Z)V", "Lnetwork/path/mobilenode/library/domain/entity/JobList;", "jobList", "getJobList", "()Lnetwork/path/mobilenode/library/domain/entity/JobList;", "setJobList", "(Lnetwork/path/mobilenode/library/domain/entity/JobList;)V", "listeners", "", "Lnetwork/path/mobilenode/library/domain/PathEngine$Listener;", "kotlin.jvm.PlatformType", "", "nativeTask", "nodeId", "getNodeId", "()Ljava/lang/String;", "setNodeId", "(Ljava/lang/String;)V", "pollTask", "retryCounter", "", "Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "status", "getStatus", "()Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "setStatus", "(Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;)V", "useProxy", "addListener", "l", "createCheckInMessage", "Lnetwork/path/mobilenode/library/domain/entity/CheckIn;", "executeServiceCall", "T", "call", "Lkotlin/Function0;", "Lretrofit2/Call;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getHttpService", "initTrueTime", "", "delay", "", "notifyRequest", "request", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "onStatusChanged", "connected", "performCheckIn", "pollJobs", "processJob", "executionUuid", "processJobs", "list", "processResult", "result", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "removeListener", "start", "startNativeProcesses", "stop", "stopNativeProcesses", "test", "toggleJobExecution", "addProxy", "Lokhttp3/OkHttpClient$Builder;", "host", "port", "Companion", "library_release"})
public final class PathHttpEngine
implements PathEngine,
NetworkMonitor.Listener {
    private final Set<PathEngine.Listener> listeners;
    private final ConcurrentHashMap<String, Boolean> currentExecutionUuids;
    private int retryCounter;
    private boolean useProxy;
    private PathService httpService;
    private Future<?> checkInTask;
    private Future<?> nativeTask;
    private Future<?> pollTask;
    @NotNull
    private ConnectionStatus status;
    @Nullable
    private String nodeId;
    @Nullable
    private JobList jobList;
    private boolean isJobExecutionRunning;
    private final PathNativeProcesses nativeProcesses;
    private final LastLocationProvider lastLocationProvider;
    private final NetworkMonitor networkMonitor;
    private final OkHttpClient okHttpClient;
    private final Gson gson;
    private final PathStorage storage;
    private final CustomThreadPoolManager threadManager;
    private boolean isTest;
    private static final long HEARTBEAT_INTERVAL_MS = 30000L;
    private static final long HEARTBEAT_INTERVAL_ERROR_MS = 5000L;
    private static final int MAX_JOBS = 10;
    private static final int MAX_RETRIES = 5;
    private static final long PROXY_RESTART_TIMEOUT = 3600000L;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConnectionStatus getStatus() {
        return this.status;
    }

    private void setStatus(ConnectionStatus value) {
        this.status = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onStatusChanged(value);
        }
    }

    @Override
    @Nullable
    public String getNodeId() {
        return this.nodeId;
    }

    private void setNodeId(String value) {
        this.nodeId = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onNodeId(value);
        }
    }

    @Override
    @Nullable
    public JobList getJobList() {
        return this.jobList;
    }

    private void setJobList(JobList value) {
        this.jobList = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onJobListReceived(value);
        }
    }

    @Override
    public boolean isJobExecutionRunning() {
        return this.isJobExecutionRunning;
    }

    private void setJobExecutionRunning(boolean value) {
        this.isJobExecutionRunning = value;
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onRunning(value);
        }
    }

    @Override
    public void start() {
        this.networkMonitor.start();
        this.networkMonitor.addListener(this);
        this.lastLocationProvider.start();
        this.httpService = this.getHttpService(false);
        this.performCheckIn(0L);
        Timber.d((String)"HTTP: started", (Object[])new Object[0]);
    }

    @Override
    public void processResult(@NotNull JobResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (Intrinsics.areEqual((Object)result2.getExecutionUuid(), (Object)"DUMMY_UUID")) {
            return;
        }
        String string = this.storage.getNodeId();
        if (string == null) {
            return;
        }
        String nodeId = string;
        CustomThreadPoolManager.run$default(this.threadManager, "processResult", 0L, (Function0)new Function0<Boolean>(this, nodeId, result2){
            final /* synthetic */ PathHttpEngine this$0;
            final /* synthetic */ String $nodeId;
            final /* synthetic */ JobResult $result;

            @Nullable
            public final Boolean invoke() {
                PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<Unit>>(this){
                    final /* synthetic */ processResult.1 this$0;

                    @Nullable
                    public final Call<Unit> invoke() {
                        PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                        return pathService != null ? pathService.postResult(this.this$0.$nodeId, this.this$0.$result.getExecutionUuid(), this.this$0.$result) : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                return (Boolean)PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0).remove(this.$result.getExecutionUuid());
            }
            {
                this.this$0 = pathHttpEngine;
                this.$nodeId = string;
                this.$result = jobResult;
                super(0);
            }
        }, 2, null);
    }

    @Override
    public void stop() {
        this.stopNativeProcesses();
        Future<?> future = this.checkInTask;
        if (future != null) {
            future.cancel(true);
        }
        Future<?> future2 = this.nativeTask;
        if (future2 != null) {
            future2.cancel(true);
        }
        Future<?> future3 = this.pollTask;
        if (future3 != null) {
            future3.cancel(true);
        }
        this.networkMonitor.removeListener(this);
        this.networkMonitor.stop();
        this.lastLocationProvider.stop();
        this.setStatus(ConnectionStatus.LOOKING);
        this.setJobList(null);
        this.setJobExecutionRunning(true);
        Timber.d((String)"HTTP: stopped", (Object[])new Object[0]);
    }

    @Override
    public boolean toggleJobExecution() {
        this.setJobExecutionRunning(!this.isJobExecutionRunning());
        Timber.d((String)("HTTP: changed status to [" + this.isJobExecutionRunning() + ']'), (Object[])new Object[0]);
        return this.isJobExecutionRunning();
    }

    @Override
    public boolean addListener(@NotNull PathEngine.Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.add(l);
    }

    @Override
    public boolean removeListener(@NotNull PathEngine.Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.remove(l);
    }

    @Override
    public void onStatusChanged(boolean connected) {
        if (connected) {
            this.performCheckIn(500L);
        }
    }

    private final void performCheckIn(long delay) {
        Future<?> future = this.checkInTask;
        if (future != null) {
            future.cancel(true);
        }
        this.checkInTask = this.threadManager.run("checkIn", delay, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                Timber.d((String)"HTTP: Checking in...", (Object[])new Object[0]);
                JobList result2 = (JobList)PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<JobList>>(this){
                    final /* synthetic */ performCheckIn.1 this$0;

                    @Nullable
                    public final Call<JobList> invoke() {
                        Call<JobList> call;
                        CheckIn checkIn = PathHttpEngine.access$createCheckInMessage(this.this$0.this$0);
                        if (checkIn != null) {
                            PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                            if (pathService != null) {
                                String string = PathHttpEngine.access$getStorage$p(this.this$0.this$0).getNodeId();
                                if (string == null) {
                                    string = "";
                                }
                                call = pathService.checkIn(string, checkIn);
                            } else {
                                call = null;
                            }
                        } else {
                            PathHttpEngine pathHttpEngine = this.this$0.this$0;
                            int n = PathHttpEngine.access$getRetryCounter$p(pathHttpEngine);
                            PathHttpEngine.access$setRetryCounter$p(pathHttpEngine, n + 1);
                            call = null;
                        }
                        return call;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                if (result2 != null) {
                    PathHttpEngine.access$processJobs(this.this$0, result2);
                } else if (this.this$0.getStatus() != ConnectionStatus.LOOKING) {
                    PathHttpEngine.access$setStatus$p(this.this$0, ConnectionStatus.DISCONNECTED);
                }
                boolean isConnected = this.this$0.getStatus() == ConnectionStatus.CONNECTED || this.this$0.getStatus() == ConnectionStatus.PROXY;
                long nextDelay = PathHttpEngine.access$getRetryCounter$p(this.this$0) > 0 || !isConnected ? 5000L : 30000L;
                Timber.d((String)("HTTP: Scheduling check-in in [" + nextDelay + " ms]"), (Object[])new Object[0]);
                PathHttpEngine.access$performCheckIn(this.this$0, nextDelay);
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void processJobs(JobList list) {
        Timber.d((String)("HTTP: received job list [" + list + ']'), (Object[])new Object[0]);
        if (list.getNodeId() != null) {
            this.setNodeId(list.getNodeId());
        }
        this.setJobList(list);
        this.setStatus(this.useProxy ? ConnectionStatus.PROXY : ConnectionStatus.CONNECTED);
        Collection collection = list.getJobs();
        if (!collection.isEmpty()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list.getJobs();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JobExecutionId jobExecutionId = (JobExecutionId)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getExecutionUuid(), (Object)false);
                collection2.add(pair);
            }
            List ids = (List)destination$iv$iv;
            MapsKt.putAll((Map)this.currentExecutionUuids, (Iterable)ids);
            this.pollJobs(0L);
        }
    }

    private final void pollJobs(long delay) {
        Future<?> future = this.pollTask;
        if (future != null) {
            future.cancel(true);
        }
        this.pollTask = this.threadManager.run("pollJobs", delay, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                block0: while (true) {
                    Object $receiver$iv = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    Map map = $receiver$iv;
                    for (Map.Entry<K, V> entry$iv : map.entrySet()) {
                        boolean it = (Boolean)entry$iv.getValue();
                        if (!(!it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    List ids = CollectionsKt.toList((Iterable)((Map)result$iv).keySet());
                    if (ids.isEmpty()) break;
                    Timber.d((String)("HTTP: " + ids.size() + " jobs to be processed"), (Object[])new Object[0]);
                    $receiver$iv = ids;
                    Iterator<T> iterator = $receiver$iv.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block0;
                        T element$iv = iterator.next();
                        String uuid = (String)element$iv;
                        Map map2 = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0);
                        Boolean bl = true;
                        map2.put(uuid, bl);
                        PathHttpEngine.access$processJob(this.this$0, uuid);
                    }
                    break;
                }
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    private final void processJob(String executionUuid) {
        CustomThreadPoolManager.run$default(this.threadManager, "processJob", 0L, (Function0)new Function0<Object>(this, executionUuid){
            final /* synthetic */ PathHttpEngine this$0;
            final /* synthetic */ String $executionUuid;

            @Nullable
            public final Object invoke() {
                Object object;
                JobRequest details2 = (JobRequest)PathHttpEngine.access$executeServiceCall(this.this$0, (Function0)new Function0<Call<JobRequest>>(this){
                    final /* synthetic */ processJob.1 this$0;

                    @Nullable
                    public final Call<JobRequest> invoke() {
                        PathService pathService = PathHttpEngine.access$getHttpService$p(this.this$0.this$0);
                        return pathService != null ? pathService.requestDetails(this.this$0.$executionUuid) : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                if (details2 != null) {
                    details2.setExecutionUuid(this.$executionUuid);
                    PathHttpEngine.access$notifyRequest(this.this$0, details2);
                    object = Unit.INSTANCE;
                } else {
                    object = PathHttpEngine.access$getCurrentExecutionUuids$p(this.this$0).remove(this.$executionUuid);
                }
                return object;
            }
            {
                this.this$0 = pathHttpEngine;
                this.$executionUuid = string;
                super(0);
            }
        }, 2, null);
    }

    private final void notifyRequest(JobRequest request) {
        Set<PathEngine.Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            PathEngine.Listener it = (PathEngine.Listener)element$iv;
            it.onRequestReceived(request);
        }
    }

    private final CheckIn createCheckInMessage() {
        int jobsToRequest;
        int n;
        Location location;
        Location location2;
        try {
            location2 = this.lastLocationProvider.location();
        }
        catch (Exception e) {
            Timber.w((Throwable)e, (String)("HTTP: could not get location: " + e), (Object[])new Object[0]);
            location2 = null;
        }
        if ((location = location2) == null) {
            Location $receiver = location2 = new Location("");
            $receiver.setLongitude(0.0);
            $receiver.setLatitude(0.0);
            location = location2;
        }
        Location location3 = location;
        boolean requestJobs = true;
        if (this.storage.getWifiSetting() == WifiSetting.WIFI_ONLY) {
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities capabilities;
                Network network = this.networkMonitor.getConnectivityManager().getActiveNetwork();
                NetworkCapabilities networkCapabilities = capabilities = this.networkMonitor.getConnectivityManager().getNetworkCapabilities(network);
                requestJobs = networkCapabilities != null && networkCapabilities.hasTransport(1);
                Timber.d((String)("HTTP: network [" + network + "], setting [" + (Object)((Object)this.storage.getWifiSetting()) + ", requestJobs = " + requestJobs), (Object[])new Object[0]);
            } else {
                NetworkInfo networkInfo;
                NetworkInfo networkInfo2 = networkInfo = this.networkMonitor.getConnectivityManager().getNetworkInfo(1);
                requestJobs = networkInfo2 != null && networkInfo2.isConnected();
                Timber.d((String)("HTTP: network info [" + networkInfo + "], setting [" + (Object)((Object)this.storage.getWifiSetting()) + "], requestJobs = " + requestJobs), (Object[])new Object[0]);
            }
        }
        if (this.isJobExecutionRunning() && requestJobs) {
            int n2 = 10 - this.currentExecutionUuids.size();
            int n3 = 0;
            n = Math.max(n2, n3);
        } else {
            n = 0;
        }
        int n4 = jobsToRequest = n;
        String string = null;
        String string2 = null;
        Map map = null;
        String string3 = null;
        String string4 = String.valueOf(location3.getLongitude());
        String string5 = String.valueOf(location3.getLatitude());
        String string6 = this.storage.getWalletAddress();
        return new CheckIn(null, this.storage.getNodeId(), string5, string4, string6, string3, map, string2, string, n4, 481, null);
    }

    private final <T> T executeServiceCall(Function0<? extends Call<T>> call) {
        Object var2_2;
        try {
            Object result2;
            Call call2 = (Call)call.invoke();
            Object object = call2 != null && (call2 = call2.execute()) != null ? call2.body() : (result2 = null);
            if (result2 != null) {
                this.retryCounter = 0;
            }
        }
        catch (Exception e) {
            Timber.w((Throwable)e, (String)("HTTP: Service call exception [" + e + ']'), (Object[])new Object[0]);
            boolean fallback = true;
            Exception exception = e;
            if (exception instanceof UnknownHostException) {
                fallback = false;
            } else if (exception instanceof HttpException && ((HttpException)e).code() == 422) {
                Object body = ((HttpException)e).response().body();
                Timber.w((String)("HTTP: exception response [" + body + ']'), (Object[])new Object[0]);
                fallback = false;
            }
            if (fallback) {
                PathHttpEngine pathHttpEngine = this;
                ++pathHttpEngine.retryCounter;
                if (pathHttpEngine.retryCounter >= 5) {
                    Timber.w((String)("HTTP: switching proxy mode to [" + !this.useProxy + ']'), (Object[])new Object[0]);
                    this.retryCounter = 0;
                    this.httpService = this.getHttpService(!this.useProxy);
                }
            }
            var2_2 = null;
        }
        return var2_2;
    }

    private final PathService getHttpService(boolean useProxy) {
        OkHttpClient client;
        OkHttpClient okHttpClient;
        String host = "127.0.0.1";
        int port = Constants.INSTANCE.getSS_LOCAL_PORT();
        Timber.d((String)("HTTP: creating new service [" + useProxy + "]..."), (Object[])new Object[0]);
        if (useProxy) {
            this.startNativeProcesses();
        }
        if (useProxy && SocketExtensionsKt.isPortInUse(port)) {
            Timber.d((String)("HTTP: proxy port [" + port + "] is in use, connecting"), (Object[])new Object[0]);
            this.useProxy = true;
            OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"okHttpClient.newBuilder()");
            okHttpClient = this.addProxy(builder, host, port).build();
        } else {
            if (useProxy) {
                Timber.d((String)("HTTP: proxy port [" + port + "] is not in use, proxy is not running"), (Object[])new Object[0]);
            } else {
                Timber.d((String)"HTTP: proxy is not required", (Object[])new Object[0]);
            }
            this.useProxy = false;
            okHttpClient = this.okHttpClient;
        }
        OkHttpClient okHttpClient2 = client = okHttpClient;
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient2, (String)"client");
        return new PathServiceImpl(okHttpClient2, this.gson, this.isTest);
    }

    private final void stopNativeProcesses() {
        Future<?> future = this.nativeTask;
        if (future != null) {
            future.cancel(true);
        }
        this.nativeTask = null;
        this.nativeProcesses.stop();
    }

    private final void startNativeProcesses() {
        this.nativeProcesses.start();
        Future<?> future = this.nativeTask;
        if (future != null) {
            future.cancel(true);
        }
        this.nativeTask = this.threadManager.run("nativeProcesses", 3600000L, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                PathHttpEngine.access$startNativeProcesses(this.this$0);
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    private final OkHttpClient.Builder addProxy(@NotNull OkHttpClient.Builder $receiver, String host, int port) {
        OkHttpClient.Builder builder = $receiver.proxy(new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(host, port))).addInterceptor((Interceptor)addProxy.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"proxy(Proxy(Proxy.Type.S\u2026l).build())\n            }");
        return builder;
    }

    private final void initTrueTime(long delay) {
        this.threadManager.run("TrueTime", delay, (Function0)new Function0<Unit>(this){
            final /* synthetic */ PathHttpEngine this$0;

            public final void invoke() {
                try {
                    TrueTime.build().withLoggingEnabled(false).withNtpHost("time.google.com").initialize();
                    Timber.d((String)"TRUE TIME: initialised", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Timber.i((Throwable)e, (String)("TRUE TIME: failed to initialise: " + e), (Object[])new Object[0]);
                    PathHttpEngine.access$initTrueTime(this.this$0, 1000L);
                }
            }
            {
                this.this$0 = pathHttpEngine;
                super(0);
            }
        });
    }

    private final void test() {
        JobRequest dummyRequest = new JobRequest(null, "", "traceroute", null, "HELLO", "www.google.com", null, null, null, null, null, null, "DUMMY_UUID", "DUMMY_UUID", 4041, null);
        this.notifyRequest(dummyRequest);
    }

    public PathHttpEngine(@NotNull PathNativeProcesses nativeProcesses, @NotNull LastLocationProvider lastLocationProvider, @NotNull NetworkMonitor networkMonitor, @NotNull OkHttpClient okHttpClient, @NotNull Gson gson, @NotNull PathStorage storage, @NotNull CustomThreadPoolManager threadManager, boolean isTest) {
        Intrinsics.checkParameterIsNotNull((Object)nativeProcesses, (String)"nativeProcesses");
        Intrinsics.checkParameterIsNotNull((Object)((Object)lastLocationProvider), (String)"lastLocationProvider");
        Intrinsics.checkParameterIsNotNull((Object)networkMonitor, (String)"networkMonitor");
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)threadManager, (String)"threadManager");
        this.nativeProcesses = nativeProcesses;
        this.lastLocationProvider = lastLocationProvider;
        this.networkMonitor = networkMonitor;
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        this.storage = storage;
        this.threadManager = threadManager;
        this.isTest = isTest;
        this.initTrueTime(0L);
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap(0));
        this.currentExecutionUuids = new ConcurrentHashMap();
        this.status = ConnectionStatus.LOOKING;
        this.nodeId = this.storage.getNodeId();
        this.isJobExecutionRunning = true;
    }

    @Nullable
    public static final /* synthetic */ Object access$executeServiceCall(PathHttpEngine $this, @NotNull Function0 call) {
        return $this.executeServiceCall(call);
    }

    @Nullable
    public static final /* synthetic */ PathService access$getHttpService$p(PathHttpEngine $this) {
        return $this.httpService;
    }

    public static final /* synthetic */ void access$setHttpService$p(PathHttpEngine $this, @Nullable PathService pathService) {
        $this.httpService = pathService;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getCurrentExecutionUuids$p(PathHttpEngine $this) {
        return $this.currentExecutionUuids;
    }

    @Nullable
    public static final /* synthetic */ CheckIn access$createCheckInMessage(PathHttpEngine $this) {
        return $this.createCheckInMessage();
    }

    @NotNull
    public static final /* synthetic */ PathStorage access$getStorage$p(PathHttpEngine $this) {
        return $this.storage;
    }

    public static final /* synthetic */ int access$getRetryCounter$p(PathHttpEngine $this) {
        return $this.retryCounter;
    }

    public static final /* synthetic */ void access$setRetryCounter$p(PathHttpEngine $this, int n) {
        $this.retryCounter = n;
    }

    public static final /* synthetic */ void access$processJobs(PathHttpEngine $this, @NotNull JobList list) {
        $this.processJobs(list);
    }

    @NotNull
    public static final /* synthetic */ ConnectionStatus access$getStatus$p(PathHttpEngine $this) {
        return $this.getStatus();
    }

    public static final /* synthetic */ void access$setStatus$p(PathHttpEngine $this, @NotNull ConnectionStatus connectionStatus) {
        $this.setStatus(connectionStatus);
    }

    public static final /* synthetic */ void access$performCheckIn(PathHttpEngine $this, long delay) {
        $this.performCheckIn(delay);
    }

    public static final /* synthetic */ void access$processJob(PathHttpEngine $this, @NotNull String executionUuid) {
        $this.processJob(executionUuid);
    }

    public static final /* synthetic */ void access$notifyRequest(PathHttpEngine $this, @NotNull JobRequest request) {
        $this.notifyRequest(request);
    }

    public static final /* synthetic */ void access$startNativeProcesses(PathHttpEngine $this) {
        $this.startNativeProcesses();
    }

    public static final /* synthetic */ void access$initTrueTime(PathHttpEngine $this, long delay) {
        $this.initTrueTime(delay);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathHttpEngine$Companion;", "", "()V", "HEARTBEAT_INTERVAL_ERROR_MS", "", "HEARTBEAT_INTERVAL_MS", "MAX_JOBS", "", "MAX_RETRIES", "PROXY_RESTART_TIMEOUT", "create", "Lnetwork/path/mobilenode/library/domain/PathEngine;", "context", "Landroid/content/Context;", "threadManager", "Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;", "okHttpClient", "Lokhttp3/OkHttpClient;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "gson", "Lcom/google/gson/Gson;", "isTest", "", "library_release"})
    public static final class Companion {
        @NotNull
        public final PathEngine create(@NotNull Context context, @NotNull CustomThreadPoolManager threadManager, @NotNull OkHttpClient okHttpClient, @NotNull PathStorage storage, @NotNull Gson gson, boolean isTest) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)threadManager, (String)"threadManager");
            Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
            Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
            Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
            NetworkMonitor networkMonitor = new NetworkMonitor(context);
            LastLocationProvider locationProvider = new LastLocationProvider(context);
            PathNativeProcessesImpl nativeProcesses = new PathNativeProcessesImpl(context, storage);
            return new PathHttpEngine(nativeProcesses, locationProvider, networkMonitor, okHttpClient, gson, storage, threadManager, isTest);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

