/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import com.google.gson.Gson;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.path.mobilenode.library.data.runner.FallbackRunner;
import network.path.mobilenode.library.data.runner.HttpRunner;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.TcpRunner;
import network.path.mobilenode.library.data.runner.TraceRunner;
import network.path.mobilenode.library.data.runner.UdpRunner;
import network.path.mobilenode.library.domain.PathJobExecutor;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnetwork/path/mobilenode/library/data/runner/PathJobExecutorImpl;", "Lnetwork/path/mobilenode/library/domain/PathJobExecutor;", "okHttpClient", "Lokhttp3/OkHttpClient;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "gson", "Lcom/google/gson/Gson;", "(Lokhttp3/OkHttpClient;Lnetwork/path/mobilenode/library/domain/PathStorage;Lcom/google/gson/Gson;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "execute", "Ljava/util/concurrent/Future;", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "request", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "start", "", "stop", "library_release"})
public final class PathJobExecutorImpl
implements PathJobExecutor {
    private ExecutorService executor;
    private final OkHttpClient okHttpClient;
    private final PathStorage storage;
    private final Gson gson;

    @Override
    public void start() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
        this.executor = executorService;
    }

    @Override
    @NotNull
    public Future<JobResult> execute(@NotNull JobRequest request) {
        Runner runner;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        JobRequest $receiver = request;
        if ($receiver.getProtocol() == null) {
            runner = FallbackRunner.INSTANCE;
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"http", (boolean)true)) {
            runner = new HttpRunner(this.okHttpClient, this.storage);
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"tcp", (boolean)true)) {
            runner = new TcpRunner();
        } else if (StringsKt.startsWith((String)$receiver.getProtocol(), (String)"udp", (boolean)true)) {
            runner = new UdpRunner();
        } else {
            String string = $receiver.getMethod();
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            runner = StringsKt.startsWith((String)string2, (String)"traceroute", (boolean)true) ? (Runner)new TraceRunner(this.gson) : (Runner)FallbackRunner.INSTANCE;
        }
        Runner runner2 = runner;
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        Future<JobResult> future = executorService.submit((Callable)new Callable<JobResult>(runner2, request){
            final /* synthetic */ Runner $runner;
            final /* synthetic */ JobRequest $request;

            @NotNull
            public final JobResult call() {
                return this.$runner.runJob(this.$request);
            }
            {
                this.$runner = runner;
                this.$request = jobRequest;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(future, (String)"executor.submit(Callable\u2026runner.runJob(request) })");
        return future;
    }

    @Override
    public void stop() {
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        executorService.shutdown();
    }

    public PathJobExecutorImpl(@NotNull OkHttpClient okHttpClient, @NotNull PathStorage storage, @NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        this.okHttpClient = okHttpClient;
        this.storage = storage;
        this.gson = gson;
    }
}

