/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.helpers.CollectionsHelper;
import network.minter.profile.api.ProfileEndpoint;
import network.minter.profile.models.PasswordChangeRequest;
import network.minter.profile.models.ProfileRequestResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.User;
import retrofit2.Call;

public class ProfileRepository
extends DataRepository<ProfileEndpoint>
implements DataRepository.Configurator {
    public ProfileRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<ProfileResult<User.Data>> getProfile() {
        return ((ProfileEndpoint)this.getInstantService()).getProfile();
    }

    public Call<ProfileResult<ProfileRequestResult>> updateProfile(@Nonnull User.Data data) {
        ProfileRepository profileRepository = this;
        Preconditions.checkNotNull((Object)data);
        return ((ProfileEndpoint)profileRepository.getInstantService(profileRepository)).updateProfile(data);
    }

    public Call<ProfileResult<ProfileRequestResult>> updateField(String string, String string2) {
        ProfileRepository profileRepository = object;
        Object object = CollectionsHelper.asMap((Object[])new String[]{string, string2});
        return ((ProfileEndpoint)profileRepository.getInstantService(profileRepository)).updateProfile((Map<String, String>)object);
    }

    public Call<ProfileResult<User.Avatar>> updateAvatar(String string) {
        ProfileRepository profileRepository = this;
        return ((ProfileEndpoint)profileRepository.getInstantService(profileRepository)).updateAvatarBase64(string);
    }

    public Call<ProfileResult<Object>> changePassword(PasswordChangeRequest passwordChangeRequest) {
        ProfileRepository profileRepository = this;
        return ((ProfileEndpoint)profileRepository.getInstantService(profileRepository)).changePassword(passwordChangeRequest);
    }

    public void configure(ApiService.Builder builder) {
        builder.authRequired();
    }

    @Nonnull
    protected Class<ProfileEndpoint> getServiceClass() {
        return ProfileEndpoint.class;
    }
}

