/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile;

import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.EncryptedString;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringSerializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterAddressSerializer;
import network.minter.core.internal.common.Lazy;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.TimberLogger;
import network.minter.profile.repo.ProfileAddressRepository;
import network.minter.profile.repo.ProfileAuthRepository;
import network.minter.profile.repo.ProfileInfoRepository;
import network.minter.profile.repo.ProfileRepository;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterProfileApi {
    private static final String BASE_API_URL = "https://my.beta.minter.network";
    private static MinterProfileApi INSTANCE;
    private ApiService.Builder mApiService = new ApiService.Builder("https://my.beta.minter.network", this.getGsonBuilder());
    private ProfileAuthRepository mAuthRepository;
    private ProfileInfoRepository mInfoRepository;
    private ProfileAddressRepository mAddressRepository;
    private ProfileRepository mProfileRepository;

    private MinterProfileApi(Lazy<String> token) {
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (profile)");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.2.2");
        this.mApiService.setDateFormat("yyyy-MM-dd HH:mm:ssX");
        this.mApiService.setAuthHeaderName("Authorization");
        this.mApiService.setTokenGetter(() -> {
            if (token == null) {
                return null;
            }
            return "Bearer " + (String)token.get();
        });
    }

    public static void initialize(Lazy<String> token) {
        MinterProfileApi.initialize(token, false, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(Lazy<String> token, boolean debug) {
        MinterProfileApi.initialize(token, debug, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(Lazy<String> token, boolean debug, Mint.Leaf logger) {
        if (INSTANCE != null) {
            return;
        }
        if (debug) {
            Mint.brew((Mint.Leaf)logger);
        }
        INSTANCE = new MinterProfileApi(token);
        MinterProfileApi.INSTANCE.mApiService.setDebug(debug);
        MinterProfileApi.INSTANCE.mApiService.setDebugRequestLevel(debug ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    public static String getCoinAvatarUrl(@Nonnull String coinName) {
        Preconditions.checkNotNull((Object)coinName, (String)"Coin name can't be null");
        Preconditions.checkArgument((coinName.length() >= 3 && coinName.length() <= 10 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 chars");
        return "https://my.beta.minter.network/api/v1/avatar/by/coin/" + coinName.toUpperCase();
    }

    public static String getUserAvatarUrl(long id) {
        return MinterProfileApi.getUserAvatarUrl(String.valueOf(id));
    }

    public static String getUserAvatarUrl(String id) {
        Preconditions.checkNotNull((Object)id, (String)"Id required");
        return "https://my.beta.minter.network/api/v1/avatar/by/user/" + id;
    }

    public static String getUserAvatarUrlByAddress(MinterAddress address) {
        return MinterProfileApi.getUserAvatarUrlByAddress(address.toString());
    }

    public static String getUserAvatarUrlByAddress(String address) {
        if (!address.startsWith("Mx")) {
            return MinterProfileApi.getUserAvatarUrl(1L);
        }
        Preconditions.checkNotNull((Object)address, (String)"address required");
        return "https://my.beta.minter.network/api/v1/avatar/by/address/" + address;
    }

    public static MinterProfileApi getInstance() {
        return INSTANCE;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressSerializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        out.registerTypeAdapter(EncryptedString.class, (Object)new EncryptedStringDeserializer());
        out.registerTypeAdapter(EncryptedString.class, (Object)new EncryptedStringSerializer());
        return out;
    }

    public ProfileAuthRepository auth() {
        if (this.mAuthRepository == null) {
            this.mAuthRepository = new ProfileAuthRepository(this.mApiService);
        }
        return this.mAuthRepository;
    }

    public ProfileInfoRepository info() {
        if (this.mInfoRepository == null) {
            this.mInfoRepository = new ProfileInfoRepository(this.mApiService);
        }
        return this.mInfoRepository;
    }

    public ProfileAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ProfileAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public ProfileRepository profile() {
        if (this.mProfileRepository == null) {
            this.mProfileRepository = new ProfileRepository(this.mApiService);
        }
        return this.mProfileRepository;
    }
}

