/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import android.support.annotation.NonNull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileAuthEndpoint;
import network.minter.profile.models.LoginData;
import network.minter.profile.models.ProfileRequestResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.RegisterData;
import network.minter.profile.models.User;
import network.minter.profile.models.UsernameData;
import retrofit2.Call;

public class ProfileAuthRepository
extends DataRepository<ProfileAuthEndpoint>
implements DataRepository.Configurator {
    public ProfileAuthRepository(@NonNull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public void configure(ApiService.Builder api) {
        api.authRequired(true);
    }

    @NonNull
    protected Class<ProfileAuthEndpoint> getServiceClass() {
        return ProfileAuthEndpoint.class;
    }

    public Call<ProfileResult<User>> login(LoginData loginData) {
        return ((ProfileAuthEndpoint)this.getService()).login(loginData);
    }

    public Call<ProfileResult<ProfileRequestResult>> register(RegisterData registerData) {
        return ((ProfileAuthEndpoint)this.getInstantService(this)).register(registerData);
    }

    public Call<ProfileResult<UsernameData>> checkUsernameAvailability(String username) {
        return ((ProfileAuthEndpoint)this.getInstantService(this)).checkUsernameAvailability(username);
    }
}

