/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import android.support.annotation.NonNull;
import java.util.List;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileAddressEndpoint;
import network.minter.profile.models.ProfileAddressData;
import network.minter.profile.models.ProfileResult;
import retrofit2.Call;

public class ProfileAddressRepository
extends DataRepository<ProfileAddressEndpoint>
implements DataRepository.Configurator {
    public ProfileAddressRepository(@NonNull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddresses() {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).getAddresses();
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddresses(int page) {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).getAddresses(page);
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddressesWithEncrypted() {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).getAddressesWithEncrypted();
    }

    public Call<ProfileResult<Object>> delete(String addressId) {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).deleteAddress(addressId);
    }

    public Call<ProfileResult<Object>> delete(ProfileAddressData address) {
        return this.delete(address.id);
    }

    public Call<ProfileResult<Object>> addAddress(ProfileAddressData data) {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).addAddress(data);
    }

    public Call<ProfileResult<Object>> updateAddress(ProfileAddressData addressData) {
        return ((ProfileAddressEndpoint)this.getInstantService(this)).updateAddress(addressData.id, addressData);
    }

    public Call<ProfileResult<Object>> setAddressMain(boolean isMain, ProfileAddressData data) {
        data.isMain = isMain;
        return ((ProfileAddressEndpoint)this.getInstantService(this)).updateAddress(data.id, data);
    }

    public void configure(ApiService.Builder api) {
        api.authRequired(true);
    }

    @NonNull
    protected Class<ProfileAddressEndpoint> getServiceClass() {
        return ProfileAddressEndpoint.class;
    }
}

