/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.api.converters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.minter.core.MinterSDK;
import network.minter.core.crypto.MinterAddress;
import network.minter.explorer.models.AddressBalance;
import network.minter.explorer.models.CoinBalance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \r2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lnetwork/minter/explorer/api/converters/ExplorerAddressBalanceDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lnetwork/minter/explorer/models/AddressBalance;", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnetwork/minter/explorer/models/AddressBalance;", "<init>", "()V", "Companion", "minter-android-explorer_netTestRelease"})
public final class ExplorerAddressBalanceDeserializer
implements JsonDeserializer<AddressBalance> {
    private static final String COINS_BALANCE = "balances";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public AddressBalance deserialize(@NotNull JsonElement object, @NotNull Type object2, @NotNull JsonDeserializationContext object3) throws JsonParseException {
        AddressBalance addressBalance;
        Intrinsics.checkNotNullParameter((Object)object, (String)"json");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)object3, (String)"context");
        if (object.isJsonNull()) {
            return null;
        }
        AddressBalance addressBalance2 = addressBalance;
        addressBalance = new AddressBalance();
        if ((object = object.getAsJsonObject()).has("address")) {
            JsonElement jsonElement = object.get("address");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"root[\"address\"]");
            if (!jsonElement.isJsonNull()) {
                JsonElement jsonElement2 = object.get("address");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"root[\"address\"]");
                addressBalance2.address = new MinterAddress((CharSequence)jsonElement2.getAsString());
            }
        }
        if (object.has("total_balance_sum")) {
            JsonElement jsonElement = object.get("total_balance_sum");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"root[\"total_balance_sum\"]");
            if (!jsonElement.isJsonNull()) {
                JsonElement jsonElement3 = object.get("total_balance_sum");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"root[\"total_balance_sum\"]");
                addressBalance2.totalBalance = jsonElement3.getAsBigDecimal();
            }
        }
        if (object.has("total_balance_sum_usd")) {
            JsonElement jsonElement = object.get("total_balance_sum_usd");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"root[\"total_balance_sum_usd\"]");
            if (!jsonElement.isJsonNull()) {
                JsonElement jsonElement4 = object.get("total_balance_sum_usd");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"root[\"total_balance_sum_usd\"]");
                addressBalance2.totalBalanceUSD = jsonElement4.getAsBigDecimal();
            }
        }
        if (object.has("stake_balance_sum")) {
            JsonElement jsonElement = object.get("stake_balance_sum");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"root[\"stake_balance_sum\"]");
            if (!jsonElement.isJsonNull()) {
                JsonElement jsonElement5 = object.get("stake_balance_sum");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"root[\"stake_balance_sum\"]");
                addressBalance2.stakeBalanceBIP = jsonElement5.getAsBigDecimal();
            }
        }
        if (object.has("stake_balance_sum_usd")) {
            JsonElement jsonElement = object.get("stake_balance_sum_usd");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"root[\"stake_balance_sum_usd\"]");
            if (!jsonElement.isJsonNull()) {
                JsonElement jsonElement6 = object.get("stake_balance_sum_usd");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"root[\"stake_balance_sum_usd\"]");
                addressBalance2.stakeBalanceUSD = jsonElement6.getAsBigDecimal();
            }
        }
        if (object.has(COINS_BALANCE)) {
            BigDecimal bigDecimal;
            HashMap hashMap;
            HashMap hashMap2;
            object = object.getAsJsonArray(COINS_BALANCE);
            object2 = hashMap2;
            hashMap2 = new HashMap();
            object3 = hashMap;
            hashMap = new HashMap();
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                JsonElement jsonElement = object.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"coins[i]");
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                JsonElement jsonElement7 = jsonObject.get("amount");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"coinData[\"amount\"]");
                bigDecimal = jsonElement7.getAsBigDecimal();
                JsonElement jsonElement8 = jsonObject.get("bip_amount");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement8, (String)"coinData[\"bip_amount\"]");
                BigDecimal bigDecimal2 = jsonElement8.getAsBigDecimal();
                JsonElement jsonElement9 = jsonObject.get("coin");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement9, (String)"coinData[\"coin\"]");
                JsonObject jsonObject2 = jsonElement9.getAsJsonObject();
                JsonElement jsonElement10 = jsonObject2.get("id");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement10, (String)"coinDataObj[\"id\"]");
                BigInteger bigInteger = jsonElement10.getAsBigInteger();
                JsonElement jsonElement11 = jsonObject2.get("symbol");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement11, (String)"coinDataObj[\"symbol\"]");
                String string = jsonElement11.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"coinDataObj[\"symbol\"].asString");
                Object object4 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"Locale.getDefault()");
                if (string != null) {
                    CoinBalance coinBalance;
                    string = string.toUpperCase((Locale)object4);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
                    if (Intrinsics.areEqual((Object)bigInteger, (Object)MinterSDK.DEFAULT_COIN_ID) ^ true && object2.containsKey(string)) {
                        string = string + '-' + (i + 1);
                    }
                    object4 = coinBalance;
                    MinterAddress minterAddress = addressBalance2.address;
                    coinBalance = new CoinBalance(bigInteger, string, bigDecimal, bigDecimal2, minterAddress);
                    object2.put(string, object4);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"coinId");
                    bigDecimal = object2.get(string);
                    Intrinsics.checkNotNull(bigDecimal);
                    object3.put(bigInteger, bigDecimal);
                    continue;
                }
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!object3.containsKey(MinterSDK.DEFAULT_COIN_ID)) {
                CoinBalance coinBalance;
                Object object5 = object3;
                BigInteger bigInteger = MinterSDK.DEFAULT_COIN_ID;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"MinterSDK.DEFAULT_COIN_ID");
                object = coinBalance;
                BigInteger bigInteger2 = MinterSDK.DEFAULT_COIN_ID;
                BigDecimal bigDecimal3 = BigDecimal.ZERO;
                bigDecimal = addressBalance2.address;
                BigDecimal bigDecimal4 = bigDecimal3;
                coinBalance = new CoinBalance(bigInteger2, "MNT", bigDecimal4, bigDecimal4, (MinterAddress)bigDecimal);
                object5.put(bigInteger, object);
                object = object5.get(MinterSDK.DEFAULT_COIN_ID);
                Intrinsics.checkNotNull(object);
                object2.put("MNT", object);
            }
            AddressBalance addressBalance3 = addressBalance2;
            addressBalance3.coins = object2;
            addressBalance3.coinsById = object3;
        }
        return addressBalance2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lnetwork/minter/explorer/api/converters/ExplorerAddressBalanceDeserializer$Companion;", "", "", "COINS_BALANCE", "Ljava/lang/String;", "<init>", "()V", "minter-android-explorer_netTestRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

