/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import network.minter.blockchain.models.BCResult;

public class BCExplorerResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="data")
    public Result result;
    public ErrorResult error;

    public static <T> BCExplorerResult<T> copyError(BCExplorerResult<?> bCExplorerResult) {
        BCExplorerResult bCExplorerResult2;
        BCExplorerResult bCExplorerResult3 = bCExplorerResult2;
        bCExplorerResult3();
        bCExplorerResult3.statusCode = bCExplorerResult.statusCode;
        bCExplorerResult2.error = bCExplorerResult.error;
        return bCExplorerResult2;
    }

    public String getMessage() {
        ErrorResult errorResult = ((BCExplorerResult)((Object)errorResult)).error;
        if (errorResult == null) {
            return null;
        }
        return errorResult.message;
    }

    public BCResult.ResultCode getErrorCode() {
        ErrorResult errorResult = ((BCExplorerResult)((Object)errorResult)).error;
        if (errorResult == null) {
            return BCResult.ResultCode.Success;
        }
        return BCResult.ResultCode.findByCode((int)errorResult.code);
    }

    @Deprecated
    public boolean isSuccess() {
        return this.isOk();
    }

    public boolean isOk() {
        return this.statusCode == 200 && this.getErrorCode() == BCResult.ResultCode.Success;
    }

    public static class ErrorResult {
        @SerializedName(value="log")
        public String message;
        public int code;
        public String data;
        @Nullable
        public String coin;
        @Nullable
        public BigDecimal value;

        public BCResult.ResultCode getResultCode() {
            return BCResult.ResultCode.findByCode((int)this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

