/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import org.parceler.Parcel;

@Parcel
public class AddressData {
    public Map<String, CoinBalance> coins = new HashMap<String, CoinBalance>();
    public long txCount;
    public MinterAddress address;

    public Map<String, CoinBalance> getCoins() {
        if (this.coins == null) {
            this.coins = new HashMap<String, CoinBalance>();
        }
        return this.coins;
    }

    public void fillDefaultsOnEmpty() {
        if (this.getCoins().isEmpty()) {
            this.coins.put("MNT", new CoinBalance("MNT", BigDecimal.ZERO, BigDecimal.ZERO));
        }
    }

    public BigDecimal getTotalBalance() {
        if (this.getCoins().isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalOut = BigDecimal.ZERO;
        for (Map.Entry<String, CoinBalance> entry : this.getCoins().entrySet()) {
            totalOut = totalOut.add(entry.getValue().getBaseCoinAmount());
        }
        return totalOut;
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigDecimal amount;
        public BigDecimal usdAmount;
        public BigDecimal baseCoinAmount;

        public CoinBalance() {
        }

        public CoinBalance(String coin, BigDecimal value, BigDecimal valueUsd) {
            this.coin = coin;
            this.amount = value;
            this.usdAmount = valueUsd;
        }

        public BigDecimal getBaseCoinAmount() {
            return (BigDecimal)MoreObjects.firstNonNull((Object)this.baseCoinAmount, (Object)BigDecimal.ZERO);
        }

        public String getCoin() {
            if (this.coin == null) {
                return null;
            }
            return this.coin.toUpperCase();
        }

        public BigDecimal getAmount() {
            return (BigDecimal)MoreObjects.firstNonNull((Object)this.amount, (Object)BigDecimal.ZERO);
        }

        public BigDecimal getUsdAmount() {
            return (BigDecimal)MoreObjects.firstNonNull((Object)this.usdAmount, (Object)BigDecimal.ZERO);
        }
    }
}

