/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.annimon.stream.Stream;
import io.reactivex.Observable;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.NodeAddressEndpoint;
import network.minter.blockchain.models.AddressInfo;
import network.minter.blockchain.models.AddressInfoList;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;

public class NodeAddressRepository
extends DataRepository<NodeAddressEndpoint> {
    public NodeAddressRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<AddressInfo> getAddressInfo(String string) {
        return ((NodeAddressEndpoint)this.getInstantService()).getAddressInfo(string);
    }

    public Observable<AddressInfo> getAddressInfo(@Nonnull MinterAddress minterAddress) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Public key required!");
        return ((NodeAddressEndpoint)this.getInstantService()).getAddressInfo(minterAddress.toString());
    }

    public Observable<AddressInfo> getAddressInfo(@Nonnull MinterAddress object, long l, boolean bl) {
        Preconditions.checkNotNull((Object)object, (String)"Public key required!");
        NodeAddressEndpoint nodeAddressEndpoint = (NodeAddressEndpoint)object2.getInstantService();
        Object object2 = object.toString();
        object = String.valueOf(l);
        String string = String.valueOf(bl);
        return nodeAddressEndpoint.getAddressInfo((String)object2, (String)object, string);
    }

    public Observable<AddressInfoList> getAddressesInfo(List<MinterAddress> object, long l, boolean bl) {
        List<MinterAddress> list = object;
        Preconditions.checkNotNull(list, (String)"Address list can't be null");
        Preconditions.checkArgument((boolean)(list.isEmpty() ^ true), (Object)"Address list should contain at least 1 address");
        NodeAddressEndpoint nodeAddressEndpoint = (NodeAddressEndpoint)object2.getInstantService();
        Object object2 = Stream.of(object).map(MinterAddress::toString).toList();
        object = String.valueOf(l);
        String string = String.valueOf(bl);
        return nodeAddressEndpoint.getAddressesInfo((List<String>)object2, (String)object, string);
    }

    public Observable<AddressInfoList> getAddressesInfo(List<MinterAddress> list) {
        List<MinterAddress> list2 = list;
        Preconditions.checkNotNull(list2, (String)"Address list can't be null");
        Preconditions.checkArgument((boolean)(list2.isEmpty() ^ true), (Object)"Address list should contain at least 1 address");
        return ((NodeAddressEndpoint)this.getInstantService()).getAddressesInfo(Stream.of(list).map(MinterAddress::toString).toList());
    }

    @Nonnull
    protected Class<NodeAddressEndpoint> getServiceClass() {
        return NodeAddressEndpoint.class;
    }
}

