/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public class TxPriceVote
extends Operation {
    public static final Parcelable.Creator<TxPriceVote> CREATOR = new Parcelable.Creator<TxPriceVote>(){

        public TxPriceVote createFromParcel(Parcel parcel) {
            return new TxPriceVote(parcel);
        }

        public TxPriceVote[] newArray(int n) {
            return new TxPriceVote[n];
        }
    };
    private BigInteger mPrice;

    public TxPriceVote() {
    }

    public TxPriceVote(@Nonnull Transaction transaction) {
        super(transaction);
    }

    public TxPriceVote(Parcel parcel) {
        super(parcel);
        this.mPrice = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxPriceVote txPriceVote = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txPriceVote.mPrice);
    }

    @Override
    public OperationType getType() {
        return OperationType.PriceVote;
    }

    public BigInteger getPrice() {
        return this.mPrice;
    }

    public TxPriceVote setPrice(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            this.mPrice = bigInteger;
            return this;
        }
        throw new IllegalArgumentException("Price must be positive number");
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        TxPriceVote txPriceVote = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mPrice";
        boolean bl = txPriceVote.mPrice != null;
        return fieldsValidationResult2.addResult(string, bl, "Price must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        this.mPrice = BytesHelper.fixBigintSignedByte((char[])this.fromRawRlp(0, (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded()));
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        return RLPBoxed.encode((Object)new Object[]{this.mPrice});
    }
}

