/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public class TxEditCoinOwner
extends Operation {
    public static final Parcelable.Creator<TxEditCoinOwner> CREATOR = new Parcelable.Creator<TxEditCoinOwner>(){

        public TxEditCoinOwner createFromParcel(Parcel parcel) {
            return new TxEditCoinOwner(parcel);
        }

        public TxEditCoinOwner[] newArray(int n) {
            return new TxEditCoinOwner[n];
        }
    };
    private String mSymbol;
    private MinterAddress mNewOwner;

    public TxEditCoinOwner() {
    }

    public TxEditCoinOwner(@Nonnull Transaction transaction) {
        super(transaction);
    }

    public TxEditCoinOwner(Parcel parcel) {
        this.mSymbol = parcel.readString();
        this.mNewOwner = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxEditCoinOwner txEditCoinOwner = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txEditCoinOwner.mSymbol);
        parcel.writeValue((Object)this.mNewOwner);
    }

    @Override
    public OperationType getType() {
        return OperationType.EditCoinOwner;
    }

    public String getSymbol() {
        return this.mSymbol.replace("\u0000", "");
    }

    public TxEditCoinOwner setSymbol(String string) {
        boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Preconditions.checkArgument((boolean)bl, (Object)String.format("Coin %s length must be from 3 to 10 symbols", objectArray2));
        objectArray2.mSymbol = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return objectArray2;
    }

    public MinterAddress getNewOwner() {
        return this.mNewOwner;
    }

    public TxEditCoinOwner setNewOwner(MinterAddress minterAddress) {
        this.mNewOwner = minterAddress;
        return this;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mSymbol";
        boolean bl = ((TxEditCoinOwner)((Object)fieldsValidationResult2)).mSymbol != null;
        TxEditCoinOwner txEditCoinOwner = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Coin symbol must be set");
        object = "mNewOwner";
        boolean bl2 = txEditCoinOwner.mNewOwner != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "New owner address must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        this.mSymbol = StringHelper.charsToString((char[])this.fromRawRlp(0, objectArray));
        this.mNewOwner = new MinterAddress(this.fromRawRlp(1, objectArray));
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        return RLPBoxed.encode((Object)new Object[]{this.mSymbol, this.mNewOwner});
    }
}

