package network.minter.blockchain.samples.candidates;

import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.CandidateItem;
import network.minter.blockchain.models.CandidateList;
import network.minter.blockchain.repo.NodeValidatorRepository;
import retrofit2.HttpException;


public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeValidatorRepository repository = MinterBlockChainSDK.getInstance().validator();

        // Get candidate by Public Key
        Observable<CandidateList> request = repository.getCandidates(new BigInteger("100"));

        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(
                        candidateList -> {
                            // do something with candidate list
                            for (CandidateItem candidate : candidateList.items) {
                                System.out.println(candidate.publicKey);
                                System.out.println(candidate.commission);
                                // etc
                            }

                        },
                        err -> {
                            // you can handle HttpException
                            if (err instanceof HttpException) {
                                System.out.println(
                                        ((HttpException) err).message()
                                );
                            } else {
                                // and do with multiple error variants everything
                                err.printStackTrace();
                            }
                        });
    }
}
