/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import io.reactivex.Observable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.NodeStatusEndpoint;
import network.minter.blockchain.models.Halts;
import network.minter.blockchain.models.MaxGasValue;
import network.minter.blockchain.models.MinGasValue;
import network.minter.blockchain.models.NetworkStatus;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;

public class NodeStatusRepository
extends DataRepository<NodeStatusEndpoint> {
    public NodeStatusRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<MinGasValue> getMinGasPrice() {
        return ((NodeStatusEndpoint)this.getInstantService()).getMinGas();
    }

    public Observable<MaxGasValue> getMaxGasPrice() {
        return ((NodeStatusEndpoint)this.getInstantService()).getMaxGas(null);
    }

    public Observable<MaxGasValue> getMaxGasPrice(BigInteger bigInteger) {
        return ((NodeStatusEndpoint)this.getInstantService()).getMaxGas(bigInteger.toString());
    }

    public Observable<Halts> getHalts(BigInteger bigInteger) {
        return ((NodeStatusEndpoint)this.getInstantService()).getHalts(bigInteger.toString());
    }

    public Observable<Halts> getHalts() {
        return ((NodeStatusEndpoint)this.getInstantService()).getHalts(null);
    }

    public Observable<NetworkStatus> getNetworkStatus() {
        return ((NodeStatusEndpoint)this.getInstantService()).getStatus();
    }

    @Nonnull
    protected Class<NodeStatusEndpoint> getServiceClass() {
        return NodeStatusEndpoint.class;
    }
}

