/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.models.NodeResult;
import network.minter.blockchain.models.operational.Transaction;
import org.parceler.Parcel;

@Parcel
public class AddressInfo
extends NodeResult {
    public List<CoinBalance> balance = Collections.emptyList();
    public List<CoinBalance> total = Collections.emptyList();
    @SerializedName(value="transaction_count")
    public BigInteger txCount;
    public BigInteger bipValue;

    public AddressInfo() {
        BigInteger bigInteger = BigInteger.ZERO;
        v0.txCount = bigInteger;
        v0.bipValue = bigInteger;
    }

    public BigDecimal getBipValueDecimal() {
        return Transaction.humanizeValue(this.bipValue);
    }

    @Parcel
    public static class CoinBalance {
        public Coin coin;
        public BigInteger value;
        @SerializedName(value="bip_value")
        public BigInteger bipValue;

        public BigDecimal getValue() {
            return Transaction.humanizeValue(this.value);
        }

        public BigDecimal getBipValue() {
            return Transaction.humanizeValue(this.bipValue);
        }
    }
}

