package network.minter.blockchain.samples.candidate;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.CandidateItem;
import network.minter.blockchain.repo.NodeValidatorRepository;
import network.minter.core.crypto.MinterPublicKey;


public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeValidatorRepository repository = MinterBlockChainSDK.getInstance().validator();

        // Get candidate by Public Key
        Observable<CandidateItem> request = repository.getCandidate(new MinterPublicKey("Mpb52951425d2517504f767215ca77a9be3e0cd788fd72443da9b174fc686a37f0"));

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
