/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class EventList {
    @SerializedName(value="events")
    public List<EventItem> events;

    @Parcel
    public static class SlashEvent
    extends BaseEvent {
        @SerializedName(value="coin")
        public String coin;
    }

    @Parcel
    public static class RewardEvent
    extends BaseEvent {
        @SerializedName(value="role")
        public String role;
    }

    @Parcel
    public static class BaseEvent {
        @SerializedName(value="address")
        public MinterAddress address;
        @SerializedName(value="amount")
        public BigInteger amount;
        @SerializedName(value="validator_pub_key")
        public MinterPublicKey validatorPublicKey;
    }

    @Parcel
    public static class EventItem {
        public Type type;
        public BaseEvent value;

        public <T extends BaseEvent> T getValue() {
            return (T)this.value;
        }
    }

    public static enum Type {
        Reward("minter/RewardEvent", RewardEvent.class),
        Slash("minter/SlashEvent", SlashEvent.class);

        private String mName;
        private Class<? extends BaseEvent> mCls;

        private Type(String string2, Class<? extends BaseEvent> clazz) {
            this.mName = string2;
            this.mCls = clazz;
        }

        public static Type findByName(String string) {
            for (Type type : Type.values()) {
                if (!type.getEventName().toLowerCase().equals(string.toLowerCase())) continue;
                return type;
            }
            return null;
        }

        public Class<? extends BaseEvent> getCls() {
            return this.mCls;
        }

        public String getEventName() {
            return this.mName;
        }
    }
}

